/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.TempDirInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.tempdir.TempDirConfiguration;
import org.spockframework.util.IThrowableFunction;
import spock.lang.TempDir;

public class TempDirExtension
implements IAnnotationDrivenExtension<TempDir> {
    private final TempDirConfiguration configuration;

    public TempDirExtension(TempDirConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visitFieldAnnotation(TempDir annotation, FieldInfo field) {
        Class<?> fieldType = field.getType();
        IThrowableFunction<Path, ?, Exception> mapper = this.createPathToFieldTypeMapper(fieldType);
        TempDirInterceptor interceptor = new TempDirInterceptor(mapper, field, this.configuration.baseDir, this.configuration.keep);
        SpecInfo specInfo = (SpecInfo)field.getParent();
        if (field.isShared()) {
            specInfo.getBottomSpec().addInterceptor(interceptor);
        } else {
            for (FeatureInfo featureInfo : specInfo.getBottomSpec().getAllFeatures()) {
                featureInfo.addIterationInterceptor(interceptor);
            }
        }
    }

    private IThrowableFunction<Path, ?, Exception> createPathToFieldTypeMapper(Class<?> fieldType) {
        if (fieldType.isAssignableFrom(Path.class) || Object.class.equals(fieldType)) {
            return p -> p;
        }
        if (fieldType.isAssignableFrom(File.class)) {
            return Path::toFile;
        }
        try {
            return arg_0 -> TempDirExtension.lambda$createPathToFieldTypeMapper$1(fieldType.getConstructor(Path.class), arg_0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor<?> constructor = fieldType.getConstructor(File.class);
                return path -> constructor.newInstance(path.toFile());
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new InvalidSpecException("@TempDir can only be used on File, Path, untyped field, or class that takes Path or File as single constructor argument.");
            }
        }
    }

    private static /* synthetic */ Object lambda$createPathToFieldTypeMapper$1(Constructor rec$, Object xva$0) throws Exception {
        return rec$.newInstance(xva$0);
    }
}

