/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.spockframework.builder.DelegatingScript;
import org.spockframework.runtime.ConfigurationBuilder;
import org.spockframework.runtime.ConfigurationScriptLoader;
import org.spockframework.runtime.DummyStackTraceFilter;
import org.spockframework.runtime.ExtensionClassesLoader;
import org.spockframework.runtime.ExtensionRunner;
import org.spockframework.runtime.GlobalExtensionRegistry;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.MasterRunSupervisor;
import org.spockframework.runtime.PlatformParameterizedSpecRunner;
import org.spockframework.runtime.StackTraceFilter;
import org.spockframework.runtime.condition.DiffedArrayRenderer;
import org.spockframework.runtime.condition.DiffedClassRenderer;
import org.spockframework.runtime.condition.DiffedCollectionRenderer;
import org.spockframework.runtime.condition.DiffedMapRenderer;
import org.spockframework.runtime.condition.DiffedObjectAsBeanRenderer;
import org.spockframework.runtime.condition.DiffedObjectAsStringRenderer;
import org.spockframework.runtime.condition.DiffedSetRenderer;
import org.spockframework.runtime.condition.IObjectRenderer;
import org.spockframework.runtime.condition.ObjectRendererService;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IThrowableFunction;
import org.spockframework.util.SpockUserHomeUtil;
import spock.config.RunnerConfiguration;

public class RunContext
implements EngineExecutionContext {
    private static final ThreadLocal<LinkedList<RunContext>> contextStacks = ThreadLocal.withInitial(LinkedList::new);
    private final String name;
    private final File spockUserHome;
    private final DelegatingScript configurationScript;
    private final List<Class<? extends IGlobalExtension>> globalExtensionClasses;
    private final List<Class<?>> globalConfigClasses;
    private final GlobalExtensionRegistry globalExtensionRegistry;
    private final IObjectRenderer<Object> diffedObjectRenderer = this.createDiffedObjectRenderer();

    private RunContext(String name, File spockUserHome, DelegatingScript configurationScript, List<Class<? extends IGlobalExtension>> globalExtensionClasses, List<Class<?>> globalConfigClasses) {
        this.name = name;
        this.spockUserHome = spockUserHome;
        this.configurationScript = configurationScript;
        this.globalExtensionClasses = globalExtensionClasses;
        this.globalConfigClasses = globalConfigClasses;
        this.globalExtensionRegistry = new GlobalExtensionRegistry(globalExtensionClasses, globalConfigClasses);
    }

    private void start() {
        this.globalExtensionRegistry.initializeGlobalExtensions();
        if (this.configurationScript != null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.build(this.globalExtensionRegistry, this.configurationScript);
        }
        this.globalExtensionRegistry.startGlobalExtensions();
    }

    void stop() {
        this.globalExtensionRegistry.stopGlobalExtensions();
    }

    public String getName() {
        return this.name;
    }

    public File getSpockUserHome() {
        return this.spockUserHome;
    }

    public ExtensionRunner createExtensionRunner(SpecInfo spec) {
        return new ExtensionRunner(spec, this.globalExtensionRegistry, this.globalExtensionRegistry);
    }

    public PlatformParameterizedSpecRunner createSpecRunner(SpecInfo spec) {
        return new PlatformParameterizedSpecRunner(new MasterRunSupervisor(spec, this.createStackTraceFilter(spec), this.diffedObjectRenderer));
    }

    public <T> T getConfiguration(Class<T> type) {
        return this.globalExtensionRegistry.getConfigurationByType(type);
    }

    private IStackTraceFilter createStackTraceFilter(SpecInfo spec) {
        RunnerConfiguration runnerConfig = this.globalExtensionRegistry.getConfigurationByType(RunnerConfiguration.class);
        return runnerConfig.filterStackTrace ? new StackTraceFilter(spec) : new DummyStackTraceFilter();
    }

    private IObjectRenderer<Object> createDiffedObjectRenderer() {
        ObjectRendererService service = new ObjectRendererService();
        service.addRenderer(Object.class, new DiffedObjectAsBeanRenderer());
        DiffedObjectAsStringRenderer asStringRenderer = new DiffedObjectAsStringRenderer();
        service.addRenderer(CharSequence.class, asStringRenderer);
        service.addRenderer(Number.class, asStringRenderer);
        service.addRenderer(Character.class, asStringRenderer);
        service.addRenderer(Boolean.class, asStringRenderer);
        service.addRenderer(Class.class, new DiffedClassRenderer());
        service.addRenderer(Collection.class, new DiffedCollectionRenderer());
        service.addRenderer(Set.class, new DiffedSetRenderer(true));
        service.addRenderer(SortedSet.class, new DiffedSetRenderer(false));
        service.addRenderer(Map.class, new DiffedMapRenderer(true));
        service.addRenderer(SortedMap.class, new DiffedMapRenderer(false));
        DiffedArrayRenderer arrayRenderer = new DiffedArrayRenderer();
        service.addRenderer(Object[].class, arrayRenderer);
        service.addRenderer(byte[].class, arrayRenderer);
        service.addRenderer(short[].class, arrayRenderer);
        service.addRenderer(int[].class, arrayRenderer);
        service.addRenderer(long[].class, arrayRenderer);
        service.addRenderer(float[].class, arrayRenderer);
        service.addRenderer(double[].class, arrayRenderer);
        service.addRenderer(char[].class, arrayRenderer);
        service.addRenderer(boolean[].class, arrayRenderer);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U extends Throwable> T withNewContext(String name, File spockUserHome, DelegatingScript configurationScript, List<Class<? extends IGlobalExtension>> extensionClasses, List<Class<?>> configClasses, boolean inheritParentExtensions, IThrowableFunction<RunContext, T, U> command) throws U {
        ArrayList<Class<? extends IGlobalExtension>> allExtensionClasses = new ArrayList<Class<? extends IGlobalExtension>>(extensionClasses);
        ArrayList allConfigClasses = new ArrayList(configClasses);
        if (inheritParentExtensions) {
            allExtensionClasses.addAll(RunContext.getCurrentExtensions());
            allConfigClasses.addAll(RunContext.getCurrentConfigs());
        }
        RunContext context = new RunContext(name, spockUserHome, configurationScript, allExtensionClasses, allConfigClasses);
        Deque contextStack = contextStacks.get();
        contextStack.addFirst(context);
        try {
            context.start();
            T t = command.apply(context);
            return t;
        }
        finally {
            contextStack.removeFirst();
            context.stop();
        }
    }

    public static RunContext get() {
        LinkedList<RunContext> contextStack = contextStacks.get();
        RunContext context = contextStack.peek();
        if (context == null) {
            context = RunContext.createBottomContext();
            contextStack.addFirst(context);
            RunContext bottomContext = context;
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(bottomContext::stop, "org.spockframework.runtime.RunContext.stop()"));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            context.start();
        }
        return context;
    }

    private static List<Class<? extends IGlobalExtension>> getCurrentExtensions() {
        RunContext context = contextStacks.get().peek();
        if (context == null) {
            return Collections.emptyList();
        }
        return context.globalExtensionClasses;
    }

    private static List<Class<?>> getCurrentConfigs() {
        RunContext context = contextStacks.get().peek();
        if (context == null) {
            return Collections.emptyList();
        }
        return context.globalConfigClasses;
    }

    static RunContext createBottomContext() {
        File spockUserHome = SpockUserHomeUtil.getSpockUserHome();
        DelegatingScript script = new ConfigurationScriptLoader(spockUserHome).loadAutoDetectedScript();
        ExtensionClassesLoader extensionClassesLoader = new ExtensionClassesLoader();
        List<Class<? extends IGlobalExtension>> classes = extensionClassesLoader.loadExtensionClassesFromDefaultLocation();
        List<Class<?>> configs = extensionClassesLoader.loadConfigClassesFromDefaultLocation();
        return new RunContext("default", spockUserHome, script, classes, configs);
    }
}

