/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.SpecElementInfo;
import org.spockframework.runtime.model.parallel.ExclusiveResource;
import org.spockframework.runtime.model.parallel.ExecutionMode;
import org.spockframework.runtime.model.parallel.ResourceAccessMode;
import org.spockframework.util.ExceptionUtil;
import spock.config.RunnerConfiguration;

public abstract class SpockNode<T extends SpecElementInfo<?, ?>>
extends AbstractTestDescriptor
implements Node<SpockExecutionContext> {
    private final RunnerConfiguration configuration;
    private final T nodeInfo;

    protected SpockNode(UniqueId uniqueId, String displayName, TestSource source, RunnerConfiguration configuration, T nodeInfo) {
        super(uniqueId, displayName, source);
        this.configuration = configuration;
        this.nodeInfo = nodeInfo;
    }

    public T getNodeInfo() {
        return this.nodeInfo;
    }

    public RunnerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void sneakyInvoke(Node.Invocation<SpockExecutionContext> invocation, SpockExecutionContext context) {
        try {
            invocation.invoke((EngineExecutionContext)context);
        }
        catch (Exception e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    protected Node.SkipResult shouldBeSkipped(ISkippable skippable) {
        return skippable.isSkipped() ? Node.SkipResult.skip((String)skippable.getSkipReason()) : Node.SkipResult.doNotSkip();
    }

    protected void verifyNotSkipped(ISkippable skippable) {
        if (skippable.isSkipped()) {
            throw new TestAbortedException(skippable.getSkipReason());
        }
    }

    public Node.ExecutionMode getExecutionMode() {
        Optional<Node.ExecutionMode> executionMode = this.getExplicitExecutionMode();
        if (executionMode.isPresent()) {
            return executionMode.get();
        }
        Optional parent = this.getParent();
        while (parent.isPresent() && parent.get() instanceof SpockNode) {
            SpockNode spockParent = (SpockNode)((Object)parent.get());
            executionMode = spockParent.getExplicitExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            executionMode = spockParent.getDefaultChildExecutionMode();
            if (executionMode.isPresent()) {
                return executionMode.get();
            }
            parent = spockParent.getParent();
        }
        return SpockNode.toExecutionMode(this.configuration.parallel.defaultExecutionMode);
    }

    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return Optional.empty();
    }

    protected Optional<Node.ExecutionMode> getExplicitExecutionMode() {
        return this.nodeInfo.getExecutionMode().map(SpockNode::toExecutionMode);
    }

    public Set<org.junit.platform.engine.support.hierarchical.ExclusiveResource> getExclusiveResources() {
        return SpockNode.toExclusiveResources(this.nodeInfo.getExclusiveResources());
    }

    protected static MethodSource featureToMethodSource(FeatureInfo info) {
        return MethodSource.from((String)((Class)info.getSpec().getBottomSpec().getReflection()).getName(), (String)info.getName(), (String)ClassUtils.nullSafeToString((Class[])((Method)info.getFeatureMethod().getReflection()).getParameterTypes()));
    }

    protected static Node.ExecutionMode toExecutionMode(ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return Node.ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return Node.ExecutionMode.SAME_THREAD;
            }
        }
        throw new SpockExecutionException("Unknown ExecutionMode: " + (Object)((Object)mode));
    }

    protected static ExclusiveResource.LockMode toLockMode(ResourceAccessMode mode) {
        switch (mode) {
            case READ_WRITE: {
                return ExclusiveResource.LockMode.READ_WRITE;
            }
            case READ: {
                return ExclusiveResource.LockMode.READ;
            }
        }
        throw new SpockExecutionException("Unknown ResourceAccessMode: " + (Object)((Object)mode));
    }

    protected static Set<org.junit.platform.engine.support.hierarchical.ExclusiveResource> toExclusiveResources(Collection<ExclusiveResource> exclusiveResources) {
        return exclusiveResources.stream().map(er -> new org.junit.platform.engine.support.hierarchical.ExclusiveResource(er.getKey(), SpockNode.toLockMode(er.getMode()))).collect(Collectors.toSet());
    }
}

