/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.TestTag;
import spock.lang.Tag;

public class TagExtension
implements IAnnotationDrivenExtension<Tag> {
    @Override
    public void visitSpecAnnotations(List<Tag> annotations, SpecInfo spec) {
        List<TestTag> tags = this.toTestTags(annotations);
        spec.getBottomSpec().getAllFeatures().forEach(f -> tags.forEach(f::addTestTag));
    }

    @Override
    public void visitFeatureAnnotations(List<Tag> annotations, FeatureInfo feature) {
        this.toTestTags(annotations).forEach(feature::addTestTag);
    }

    @NotNull
    private List<TestTag> toTestTags(List<Tag> annotations) {
        return annotations.stream().map(Tag::value).map(TestTag::create).collect(Collectors.toList());
    }
}

