/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IExcludable;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.Invoker;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;

public class MethodInfo
extends NodeInfo<SpecInfo, Method>
implements IExcludable,
IInterceptable {
    public static final Object MISSING_ARGUMENT = new Object();
    private MethodKind kind;
    private FeatureInfo feature;
    private IterationInfo iteration;
    private boolean excluded = false;
    private final List<IMethodInterceptor> interceptors = new ArrayList<IMethodInterceptor>();
    private Invoker invoker;
    private List<ParameterInfo> parameters;

    public MethodInfo() {
        this.invoker = (target, arguments) -> ReflectionUtil.invokeMethod(target, (Method)this.getReflection(), arguments);
    }

    public MethodInfo(Invoker invoker) {
        this.invoker = invoker;
    }

    public MethodInfo(MethodInfo other) {
        this.kind = other.kind;
        this.feature = other.feature;
        this.iteration = other.iteration;
        this.excluded = other.excluded;
        this.setName(other.getName());
        this.setLine(other.getLine());
        this.setParent(other.getParent());
        this.setReflection(other.getReflection());
        this.setMetadata(other.getMetadata());
        this.interceptors.addAll(other.interceptors);
        this.invoker = other.invoker;
    }

    public MethodKind getKind() {
        return this.kind;
    }

    public void setKind(MethodKind kind) {
        this.kind = kind;
    }

    public FeatureInfo getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureInfo feature) {
        this.feature = feature;
    }

    public IterationInfo getIteration() {
        return this.iteration;
    }

    public void setIteration(IterationInfo iteration) {
        this.iteration = iteration;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    @Override
    public List<IMethodInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(IMethodInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public boolean hasBytecodeName(String name) {
        return ((Method)this.getReflection()).getName().equals(name);
    }

    public List<ParameterInfo> getParameters() {
        if (this.parameters == null) {
            Function<Integer, String> nameProvider = this.getNameProvider();
            Parameter[] params = ((Method)this.getReflection()).getParameters();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(params.length);
            for (int i = 0; i < params.length; ++i) {
                result.add(new ParameterInfo(this, nameProvider.apply(i), params[i]));
            }
            this.parameters = Collections.unmodifiableList(result);
        }
        return this.parameters;
    }

    public Object invoke(Object target, Object ... arguments) throws Throwable {
        int argCount = arguments.length;
        for (int i = 0; i < argCount; ++i) {
            if (arguments[i] != MISSING_ARGUMENT) continue;
            Function<Integer, String> nameProvider = this.getNameProvider();
            StringJoiner missingArguments = new StringJoiner("', '", "No argument was provided for parameters: '", "' in method: '" + ((Method)this.getReflection()).getDeclaringClass().getName() + "." + this.getName() + "'");
            missingArguments.add(nameProvider.apply(i));
            for (int j = i + 1; j < argCount; ++j) {
                if (arguments[j] != MISSING_ARGUMENT) continue;
                missingArguments.add(nameProvider.apply(j));
            }
            throw new SpockExecutionException(missingArguments.toString());
        }
        return this.invoker.invoke(target, arguments);
    }

    @NotNull
    private Function<Integer, String> getNameProvider() {
        if (this.getKind() == MethodKind.FEATURE) {
            List<String> parameterNames = this.getFeature().getParameterNames();
            return parameterNames::get;
        }
        Parameter[] parameters = ((Method)this.getReflection()).getParameters();
        return index -> parameters[index].getName();
    }
}

