/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataVariableMap
extends AbstractMap<String, Object> {
    private final List<String> dataVariableNames;
    private final Object[] dataValues;
    private Set<Map.Entry<String, Object>> entrySet;

    public DataVariableMap(List<String> dataVariableNames, Object[] dataValues) {
        this.dataVariableNames = Objects.requireNonNull(dataVariableNames);
        this.dataValues = Objects.requireNonNull(dataValues);
        if (dataVariableNames.size() != dataValues.length) {
            throw new IllegalArgumentException("the parameters must have the same length");
        }
    }

    @Override
    public int size() {
        return this.dataValues.length;
    }

    @Override
    public boolean isEmpty() {
        return this.dataValues.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dataVariableNames.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Arrays.stream(this.dataValues).anyMatch(value::equals);
    }

    @Override
    public Object get(Object key) {
        int entryIndex = this.dataVariableNames.indexOf(key);
        return entryIndex == -1 ? null : this.dataValues[entryIndex];
    }

    @Override
    @Nullable
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    implements Set<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return DataVariableMap.this.dataValues.length;
        }

        @Override
        public boolean isEmpty() {
            return DataVariableMap.this.dataValues.length == 0;
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            int entryIndex = DataVariableMap.this.dataVariableNames.indexOf(entry.getKey());
            return entryIndex != -1 && Objects.equals(DataVariableMap.this.dataValues[entryIndex], entry.getValue());
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < DataVariableMap.this.dataValues.length;
                }

                @Override
                public Map.Entry<String, Object> next() {
                    return new AbstractMap.SimpleImmutableEntry<String, Object>((String)DataVariableMap.this.dataVariableNames.get(this.i), DataVariableMap.this.dataValues[this.i++]);
                }
            };
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            T[] result = a.length >= DataVariableMap.this.dataValues.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), DataVariableMap.this.dataValues.length);
            Iterator<Map.Entry<String, Object>> it = this.iterator();
            for (int i = 0; i < result.length; ++i) {
                if (!it.hasNext()) {
                    result[i] = null;
                    break;
                }
                result[i] = it.next();
            }
            return result;
        }

        @Override
        public boolean add(Map.Entry<String, Object> stringObjectEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return c.stream().allMatch(this::contains);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Map.Entry<String, Object>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

