/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.Closure;
import java.lang.reflect.Type;
import java.util.List;
import org.spockframework.builder.BuilderHelper;
import org.spockframework.builder.ClosureBlueprint;
import org.spockframework.builder.IBlueprint;
import org.spockframework.builder.IGestalt;
import org.spockframework.builder.ISlot;
import org.spockframework.builder.ISlotFactory;
import org.spockframework.builder.Sculpturer;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.GenericTypeReflectorUtil;

public class PojoGestalt
implements IGestalt {
    private final Object pojo;
    private final Type pojoType;
    private final IBlueprint blueprint;
    private final List<ISlotFactory> slotFactories;

    public PojoGestalt(Object pojo, Type pojoType, IBlueprint blueprint, List<ISlotFactory> slotFactories) {
        this.pojo = pojo;
        this.pojoType = pojoType;
        this.blueprint = blueprint;
        this.slotFactories = slotFactories;
    }

    public Object getSubject() {
        return this.pojo;
    }

    @Override
    public IBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public Object getProperty(String name) {
        return GroovyRuntimeUtil.getProperty(this.pojo, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        GroovyRuntimeUtil.setProperty(this.pojo, name, value);
    }

    @Override
    public Object invokeMethod(String name, Object[] args) {
        ISlot slot = this.findSlot(name, args);
        if (slot != null) {
            PojoGestalt gestalt = this.createGestalt(slot.getType(), args);
            new Sculpturer().$form(gestalt);
            slot.write(gestalt.getSubject());
            return gestalt.getSubject();
        }
        if (GroovyRuntimeUtil.getMetaClass(this.pojo).getMetaMethod(name, args) != null) {
            return GroovyRuntimeUtil.invokeMethod(this.pojo, name, args);
        }
        throw new RuntimeException(String.format("Cannot find a slot named '%s'", name));
    }

    private ISlot findSlot(String name, Object[] args) {
        for (ISlotFactory factory : this.slotFactories) {
            ISlot slot = factory.create(this.pojo, this.pojoType, name);
            if (slot == null) continue;
            return slot;
        }
        return null;
    }

    private PojoGestalt createGestalt(Type newType, Object[] args) {
        Closure closure = null;
        if (args != null && args.length > 0 && args[args.length - 1] instanceof Closure) {
            closure = (Closure)args[args.length - 1];
            args = CollectionUtil.copyArray(args, 0, args.length - 1);
        }
        Class<?> newClazz = GenericTypeReflectorUtil.erase(newType);
        Object newPojo = BuilderHelper.createInstance(newClazz, args);
        ClosureBlueprint newBlueprint = closure == null ? null : new ClosureBlueprint(closure, newPojo);
        return new PojoGestalt(newPojo, newType, newBlueprint, this.slotFactories);
    }
}

