/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.io.File;
import java.lang.annotation.Repeatable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.spockframework.compiler.AbstractSpecVisitor;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.SetupBlock;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.runtime.extension.ExtensionAnnotation;
import org.spockframework.runtime.model.BlockKind;
import org.spockframework.util.ObjectUtil;

public class SpecAnnotator
extends AbstractSpecVisitor {
    private final AstNodeCache nodeCache;
    private ListExpression blockAnnElems;

    public SpecAnnotator(AstNodeCache nodeCache) {
        this.nodeCache = nodeCache;
    }

    @Override
    public void visitSpec(Spec spec) throws Exception {
        this.addSpecMetadata(spec);
        this.addRepeatedExtensionAnnotations((AnnotatedNode)spec.getAst());
    }

    private void addSpecMetadata(Spec spec) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.SpecMetadata);
        String pathname = ((ClassNode)spec.getAst()).getModule().getContext().getName();
        String filename = new File(pathname).getName();
        ann.setMember("filename", (Expression)new ConstantExpression((Object)filename));
        ann.setMember("line", (Expression)AstUtil.primitiveConstExpression(((ClassNode)spec.getAst()).getLineNumber()));
        ((ClassNode)spec.getAst()).addAnnotation(ann);
    }

    @Override
    public void visitField(Field field) throws Exception {
        this.addFieldMetadata(field);
        this.addRepeatedExtensionAnnotations((AnnotatedNode)field.getAst());
    }

    private void addFieldMetadata(Field field) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.FieldMetadata);
        ann.setMember("name", (Expression)new ConstantExpression((Object)field.getName()));
        ann.setMember("ordinal", (Expression)AstUtil.primitiveConstExpression(field.getOrdinal()));
        ann.setMember("line", (Expression)AstUtil.primitiveConstExpression(((FieldNode)field.getAst()).getLineNumber()));
        ann.setMember("initializer", (Expression)AstUtil.primitiveConstExpression(field.hasInitialExpression()));
        ((FieldNode)field.getAst()).addAnnotation(ann);
    }

    @Override
    public void visitMethod(Method method) throws Exception {
        if (method instanceof FeatureMethod) {
            this.addFeatureMetadata((FeatureMethod)method);
        }
        if (method instanceof FeatureMethod || method instanceof FixtureMethod) {
            this.addRepeatedExtensionAnnotations((AnnotatedNode)method.getAst());
        }
    }

    private void addRepeatedExtensionAnnotations(AnnotatedNode annotatedNode) {
        ListExpression repeatedExtensionAnnotations = annotatedNode.getAnnotations().stream().flatMap(this::flattenRepeatableExtensionAnnotationContainer).filter(this::isRepeatableExtensionAnnotation).collect(Collectors.groupingBy(AnnotationNode::getClassNode)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).map(ClassExpression::new).collect(Collectors.collectingAndThen(Collectors.toList(), ListExpression::new));
        if (repeatedExtensionAnnotations.getExpressions().size() != 0) {
            AnnotationNode ann = new AnnotationNode(this.nodeCache.RepeatedExtensionAnnotations);
            ann.setMember("value", (Expression)repeatedExtensionAnnotations);
            annotatedNode.addAnnotation(ann);
        }
    }

    private Stream<? extends AnnotationNode> flattenRepeatableExtensionAnnotationContainer(AnnotationNode container) {
        Stream<AnnotationNode> result = Stream.of(container);
        Expression value = container.getMember("value");
        if (value instanceof ListExpression) {
            List valueExpressions = ObjectUtil.asInstance(value, ListExpression.class).getExpressions();
            switch (valueExpressions.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    result = this.handleSingleContainedAnnotation(container, result, (Expression)valueExpressions.get(0));
                    break;
                }
                default: {
                    result = this.handleMultipleContainedAnnotations(container, result, valueExpressions);
                    break;
                }
            }
        } else if (value instanceof AnnotationConstantExpression) {
            result = this.handleSingleContainedAnnotation(container, result, value);
        }
        return result;
    }

    private Stream<? extends AnnotationNode> handleSingleContainedAnnotation(AnnotationNode container, Stream<? extends AnnotationNode> result, Expression value) {
        if (this.notRepeatedAnnotation(value, container)) {
            return result;
        }
        AnnotationNode annotationNode = ObjectUtil.asInstance(ObjectUtil.asInstance(value, AnnotationConstantExpression.class).getValue(), AnnotationNode.class);
        return Stream.concat(result, Stream.of(annotationNode, annotationNode));
    }

    private Stream<? extends AnnotationNode> handleMultipleContainedAnnotations(AnnotationNode container, Stream<? extends AnnotationNode> result, List<Expression> valueExpressions) {
        if (this.notRepeatedAnnotation(valueExpressions.get(0), container)) {
            return result;
        }
        return Stream.concat(result, valueExpressions.stream().map(AnnotationConstantExpression.class::cast).map(ConstantExpression::getValue).map(AnnotationNode.class::cast));
    }

    private boolean notRepeatedAnnotation(Expression clazz, AnnotationNode container) {
        AnnotationNode repeatableAnnotation = AstUtil.getAnnotation((ASTNode)clazz.getType(), Repeatable.class);
        return repeatableAnnotation == null || !repeatableAnnotation.getMember("value").getType().equals((Object)container.getClassNode());
    }

    private boolean isRepeatableExtensionAnnotation(AnnotationNode annotation) {
        ClassNode annotationClass = annotation.getClassNode();
        return AstUtil.hasAnnotation((ASTNode)annotationClass, ExtensionAnnotation.class) && AstUtil.hasAnnotation((ASTNode)annotationClass, Repeatable.class);
    }

    private void addFeatureMetadata(FeatureMethod feature) {
        AnnotationNode ann = new AnnotationNode(this.nodeCache.FeatureMetadata);
        ann.setMember("name", (Expression)new ConstantExpression((Object)feature.getName()));
        ann.setMember("ordinal", (Expression)AstUtil.primitiveConstExpression(feature.getOrdinal()));
        ann.setMember("line", (Expression)AstUtil.primitiveConstExpression(((MethodNode)feature.getAst()).getLineNumber()));
        this.blockAnnElems = new ListExpression();
        ann.setMember("blocks", (Expression)this.blockAnnElems);
        ListExpression paramNames = new ListExpression();
        for (Parameter param : ((MethodNode)feature.getAst()).getParameters()) {
            paramNames.addExpression((Expression)new ConstantExpression((Object)param.getName()));
        }
        ann.setMember("parameterNames", (Expression)paramNames);
        ((MethodNode)feature.getAst()).addAnnotation(ann);
    }

    private void addBlockMetadata(Block block, BlockKind kind) {
        AnnotationNode blockAnn = new AnnotationNode(this.nodeCache.BlockMetadata);
        blockAnn.setMember("kind", (Expression)new PropertyExpression((Expression)new ClassExpression(this.nodeCache.BlockKind), kind.name()));
        ListExpression textExprs = new ListExpression();
        for (String text : block.getDescriptions()) {
            textExprs.addExpression((Expression)new ConstantExpression((Object)text));
        }
        blockAnn.setMember("texts", (Expression)textExprs);
        this.blockAnnElems.addExpression((Expression)new AnnotationConstantExpression(blockAnn));
    }

    @Override
    public void visitSetupBlock(SetupBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.SETUP);
    }

    @Override
    public void visitExpectBlock(ExpectBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.EXPECT);
    }

    @Override
    public void visitWhenBlock(WhenBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.WHEN);
    }

    @Override
    public void visitThenBlock(ThenBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.THEN);
    }

    @Override
    public void visitCleanupBlock(CleanupBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.CLEANUP);
    }

    @Override
    public void visitWhereBlock(WhereBlock block) throws Exception {
        this.addBlockMetadata(block, BlockKind.WHERE);
    }
}

