/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.lang;

import groovy.lang.Closure;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SecondParam;
import groovy.transform.stc.ThirdParam;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.spockframework.lang.ISpecificationContext;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.MockUtil;
import org.spockframework.mock.runtime.CompositeMockFactory;
import org.spockframework.mock.runtime.JavaMockFactory;
import org.spockframework.mock.runtime.MockConfiguration;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.WrongExceptionThrownError;
import org.spockframework.util.ObjectUtil;
import spock.lang.Specification;
import spock.mock.IMockMakerSettings;

public abstract class SpecInternals {
    private static final MockUtil MOCK_UTIL = new MockUtil();
    private final ISpecificationContext specificationContext = new SpecificationContext();

    public ISpecificationContext getSpecificationContext() {
        return this.specificationContext;
    }

    public <T> T createMock(String name, Type type, MockNature nature, MockImplementation implementation, Map<String, Object> options, Closure<?> closure) {
        return this.createMock(name, null, type, nature, implementation, options, closure);
    }

    public <T> T createMock(String name, T instance, Type type, MockNature nature, MockImplementation implementation, Map<String, Object> options, Closure<?> closure) {
        Object mock = CompositeMockFactory.INSTANCE.create(new MockConfiguration(name, type, instance, nature, implementation, options), (Specification)this);
        if (closure != null) {
            GroovyRuntimeUtil.invokeClosure(closure, mock);
        }
        return ObjectUtil.uncheckedCast(mock);
    }

    private void createStaticMock(Type type, MockNature nature, Map<String, Object> options) {
        MockConfiguration configuration = new MockConfiguration(null, type, null, nature, MockImplementation.JAVA, options);
        JavaMockFactory.INSTANCE.createStaticMock(configuration, (Specification)this);
    }

    <T> T oldImpl(T expression) {
        return expression;
    }

    <T extends Throwable> T thrownImpl(String inferredName, Class<T> inferredType) {
        return (T)((Throwable)inferredType.cast(this.checkExceptionThrown(inferredType)));
    }

    Throwable thrownImpl(String inferredName, Class<? extends Throwable> inferredType, Class<? extends Throwable> specifiedType) {
        return this.checkExceptionThrown(specifiedType == null ? inferredType : specifiedType);
    }

    Throwable checkExceptionThrown(Class<? extends Throwable> exceptionType) {
        if (exceptionType == null) {
            throw new InvalidSpecException("Thrown exception type cannot be inferred automatically. Please specify a type explicitly (e.g. 'thrown(MyException)').");
        }
        if (!Throwable.class.isAssignableFrom(exceptionType)) {
            throw new InvalidSpecException("Invalid exception condition: '%s' is not a (subclass of) java.lang.Throwable").withArgs(exceptionType.getSimpleName());
        }
        Throwable actual = this.specificationContext.getThrownException();
        if (exceptionType.isInstance(actual)) {
            return actual;
        }
        throw new WrongExceptionThrownError(exceptionType, actual);
    }

    <T> T MockImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, Collections.emptyMap(), null, null);
    }

    <T> T MockImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, Collections.emptyMap(), null, closure);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, options, null, null);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, options, null, closure);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, null);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, options, specifiedType, null);
    }

    <T> T MockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.JAVA, options, specifiedType, closure);
    }

    <T> T StubImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, Collections.emptyMap(), null, null);
    }

    <T> T StubImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, Collections.emptyMap(), null, closure);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, options, null, null);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, options, null, closure);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, null);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, options, specifiedType, null);
    }

    <T> T StubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.JAVA, options, specifiedType, closure);
    }

    <T> T SpyImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, Collections.emptyMap(), null, null);
    }

    <T> T SpyImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, Collections.emptyMap(), null, closure);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, options, null, null);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, options, null, closure);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, null);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, options, specifiedType, null);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.JAVA, options, specifiedType, closure);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, T instance) {
        return this.SpyImpl(inferredName, inferredType, instance, null);
    }

    <T> T SpyImpl(String inferredName, Class<?> inferredType, T instance, @ClosureParams(value=ThirdParam.class) Closure<?> closure) {
        if (instance == null) {
            throw new SpockException("Spy instance may not be null");
        }
        if (MOCK_UTIL.isMock(instance)) {
            throw new SpockException("Spy instance may not be another mock object.");
        }
        return this.createMockImpl(inferredName, (Class)ObjectUtil.uncheckedCast(instance.getClass()), instance, MockNature.SPY, MockImplementation.JAVA, Collections.singletonMap("useObjenesis", true), null, closure);
    }

    <T> T GroovyMockImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, Collections.emptyMap(), null, null);
    }

    <T> T GroovyMockImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, Collections.emptyMap(), null, closure);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, options, null, null);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, options, null, closure);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, null);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, options, specifiedType, null);
    }

    <T> T GroovyMockImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.MOCK, MockImplementation.GROOVY, options, specifiedType, closure);
    }

    <T> T GroovyStubImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, Collections.emptyMap(), null, null);
    }

    <T> T GroovyStubImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, Collections.emptyMap(), null, closure);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, options, null, null);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, options, null, closure);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, null);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, options, specifiedType, null);
    }

    <T> T GroovyStubImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.STUB, MockImplementation.GROOVY, options, specifiedType, closure);
    }

    <T> T GroovySpyImpl(String inferredName, Class<T> inferredType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, Collections.emptyMap(), null, null);
    }

    <T> T GroovySpyImpl(String inferredName, Class<T> inferredType, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, Collections.emptyMap(), null, closure);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, options, null, null);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, options, null, closure);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, null);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, Collections.emptyMap(), specifiedType, closure);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, options, specifiedType, null);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, MockNature.SPY, MockImplementation.GROOVY, options, specifiedType, closure);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, T instance) {
        return this.GroovySpyImpl(inferredName, inferredType, instance, null);
    }

    <T> T GroovySpyImpl(String inferredName, Class<?> inferredType, T instance, Closure<?> closure) {
        if (instance == null) {
            throw new SpockException("GroovySpy instance may not be null");
        }
        if (MOCK_UTIL.isMock(instance)) {
            throw new SpockException("GroovySpy instance may not be another mock object.");
        }
        return this.createMockImpl(inferredName, instance.getClass(), instance, MockNature.SPY, MockImplementation.GROOVY, Collections.singletonMap("useObjenesis", true), null, closure);
    }

    private <T> T createMockImpl(String inferredName, Class<?> inferredType, MockNature nature, MockImplementation implementation, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        return this.createMockImpl(inferredName, inferredType, null, nature, implementation, options, specifiedType, closure);
    }

    private <T> T createMockImpl(String inferredName, Class<?> inferredType, T instance, MockNature nature, MockImplementation implementation, Map<String, Object> options, Class<?> specifiedType, Closure<?> closure) {
        Class<?> effectiveType;
        Type type = specifiedType != null ? specifiedType : (effectiveType = options.containsKey("type") ? (Type)options.get("type") : inferredType);
        if (effectiveType == null) {
            throw new InvalidSpecException("Mock object type cannot be inferred automatically. Please specify a type explicitly (e.g. 'Mock(Person)').");
        }
        return this.createMock(inferredName, instance, effectiveType, nature, implementation, options, closure);
    }

    void SpyStaticImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType) {
        this.createStaticMockImpl(MockNature.SPY, specifiedType, null);
    }

    void SpyStaticImpl(String inferredName, Class<?> inferredType, Class<?> specifiedType, IMockMakerSettings mockMakerSettings) {
        this.createStaticMockImpl(MockNature.SPY, specifiedType, mockMakerSettings);
    }

    private void createStaticMockImpl(MockNature nature, Class<?> specifiedType, IMockMakerSettings mockMakerSettings) {
        if (specifiedType == null) {
            throw new InvalidSpecException("The type must not be null.");
        }
        Map<String, Object> options = Collections.emptyMap();
        if (mockMakerSettings != null) {
            options = Collections.singletonMap("mockMaker", mockMakerSettings);
        }
        this.createStaticMock(specifiedType, nature, options);
    }
}

