/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.CglibMockInterceptorAdapter;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.MockInstantiator;

class CglibMockFactory {
    private static final Class<?>[] CLASSES = new Class[0];

    CglibMockFactory() {
    }

    static Object createMock(IMockMaker.IMockCreationSettings settings) {
        Class<?> type = settings.getMockType();
        ConstructorFriendlyEnhancer enhancer = new ConstructorFriendlyEnhancer();
        enhancer.setClassLoader(settings.getClassLoader());
        ArrayList interfaces = new ArrayList(settings.getAdditionalInterface());
        interfaces.add(ISpockMockObject.class);
        if (!type.isInterface()) {
            enhancer.setSuperclass(type);
        } else {
            interfaces.add(type);
        }
        enhancer.setInterfaces(interfaces.toArray(CLASSES));
        enhancer.setCallbackFilter(BridgeMethodAwareCallbackFilter.INSTANCE);
        CglibMockInterceptorAdapter cglibInterceptor = new CglibMockInterceptorAdapter(settings.getMockInterceptor());
        enhancer.setCallbackTypes(new Class[]{cglibInterceptor.getClass(), NoOp.class});
        Class enhancedType = enhancer.createClass();
        Object proxy = MockInstantiator.instantiate(type, enhancedType, settings.getConstructorArgs(), settings.isUseObjenesis());
        ((Factory)proxy).setCallbacks(new Callback[]{cglibInterceptor, NoOp.INSTANCE});
        return proxy;
    }

    static class BridgeMethodAwareCallbackFilter
    implements CallbackFilter {
        static BridgeMethodAwareCallbackFilter INSTANCE = new BridgeMethodAwareCallbackFilter();

        BridgeMethodAwareCallbackFilter() {
        }

        public int accept(Method method) {
            if (!method.isBridge()) {
                return 0;
            }
            Object[] prmTypes = method.getParameterTypes();
            String methodName = method.getName();
            for (Class<?> superclass = method.getDeclaringClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                for (Method m : superclass.getDeclaredMethods()) {
                    if (!methodName.equals(m.getName()) || !Arrays.equals(prmTypes, m.getParameterTypes())) continue;
                    int modifiers = m.getModifiers();
                    if (Modifier.isAbstract(modifiers)) {
                        return 1;
                    }
                    return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) ? 0 : 1;
                }
            }
            return 1;
        }
    }

    static class ConstructorFriendlyEnhancer
    extends Enhancer {
        ConstructorFriendlyEnhancer() {
        }

        protected void filterConstructors(Class clazz, List constructors) {
        }
    }
}

