/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.GroovyMockInterceptor;
import org.spockframework.mock.runtime.GroovyMockMetaClass;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockCreationSettings;
import org.spockframework.mock.runtime.MockInstantiator;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.parallel.ExclusiveResource;
import org.spockframework.runtime.model.parallel.ResourceAccessMode;
import org.spockframework.util.ReflectionUtil;
import org.spockframework.util.SpockDocLinks;
import spock.config.RunnerConfiguration;
import spock.lang.Specification;

public class GroovyMockFactory
implements IMockFactory {
    private static final ExclusiveResource META_CLASS_REGISTRY_RW = new ExclusiveResource("groovy.lang.GroovySystem.metaClassRegistry", ResourceAccessMode.READ_WRITE);
    private static final ExclusiveResource GLOBAL_LOCK = new ExclusiveResource("org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY", ResourceAccessMode.READ_WRITE);
    public static final GroovyMockFactory INSTANCE = new GroovyMockFactory();

    @Override
    public boolean canCreate(IMockConfiguration configuration) {
        return configuration.getImplementation() == MockImplementation.GROOVY;
    }

    @Override
    public Object create(IMockConfiguration configuration, Specification specification) throws CannotCreateMockException {
        boolean hasAdditionalInterfaces;
        Class<?> type = configuration.getType();
        MetaClass oldMetaClass = GroovyRuntimeUtil.getMetaClass(configuration.getType());
        if (oldMetaClass instanceof GroovyMockMetaClass) {
            throw new CannotCreateMockException(type, ". The given type is already mocked by Spock.");
        }
        GroovyMockMetaClass newMetaClass = new GroovyMockMetaClass(configuration, specification, oldMetaClass);
        boolean bl = hasAdditionalInterfaces = !configuration.getAdditionalInterfaces().isEmpty();
        if (configuration.isGlobal()) {
            if (!this.isIsolatedOrHasMetaClassRegistryReadWriteLock(specification)) {
                throw new CannotCreateMockException(type, ". Global mocking in parallel execution mode is only possible, when the specification is @Isolated, or the specification or feature is annotated with @ResourceLock(org.spockframework.runtime.model.parallel.Resources.META_CLASS_REGISTRY).");
            }
            if (type.isInterface()) {
                throw new CannotCreateMockException(type, ". Global mocking is only possible for classes, but not for interfaces.");
            }
            if (hasAdditionalInterfaces) {
                throw new CannotCreateMockException(type, ". Global cannot add additionalInterfaces.");
            }
            GroovyRuntimeUtil.setMetaClass(type, (MetaClass)newMetaClass);
            specification.getSpecificationContext().getCurrentIteration().addCleanup(() -> GroovyRuntimeUtil.setMetaClass(type, oldMetaClass));
            if (this.isAbstractClass(type)) {
                return this.createProxyObjectForAbstractGlobalMock(configuration, specification, newMetaClass);
            }
            return MockInstantiator.instantiate(type, type, configuration.getConstructorArgs(), configuration.isUseObjenesis());
        }
        if (this.isFinalClass(type)) {
            if (hasAdditionalInterfaces) {
                throw new CannotCreateMockException(type, ". Cannot add additionalInterfaces to final classes.");
            }
            Object instance = MockInstantiator.instantiate(type, type, configuration.getConstructorArgs(), configuration.isUseObjenesis());
            GroovyRuntimeUtil.setMetaClass(instance, (MetaClass)newMetaClass);
            return instance;
        }
        GroovyMockInterceptor mockInterceptor = new GroovyMockInterceptor(configuration, specification, (MetaClass)newMetaClass);
        Object proxy = this.createMockObject(configuration, specification, mockInterceptor);
        if (hasAdditionalInterfaces) {
            MetaClass oldMetaClassOfProxy = GroovyRuntimeUtil.getMetaClass(proxy.getClass());
            GroovyMockMetaClass mockMetaClass = new GroovyMockMetaClass(configuration, specification, oldMetaClassOfProxy);
            mockInterceptor.setMetaClass((MetaClass)mockMetaClass);
        }
        if (configuration.getNature() == MockNature.SPY && configuration.getInstance() != null) {
            try {
                ReflectionUtil.deepCopyFields(configuration.getInstance(), proxy);
            }
            catch (Exception e) {
                throw new CannotCreateMockException(type, ". Cannot copy fields.\n" + SpockDocLinks.SPY_ON_JAVA_17.getLink(), e);
            }
        }
        return proxy;
    }

    private boolean isIsolatedOrHasMetaClassRegistryReadWriteLock(Specification specification) {
        if (!RunContext.get().getConfiguration(RunnerConfiguration.class).parallel.enabled) {
            return true;
        }
        FeatureInfo feature = specification.getSpecificationContext().getCurrentIteration().getFeature();
        Set<ExclusiveResource> specExclusiveResources = feature.getSpec().getExclusiveResources();
        if (specExclusiveResources.contains(GLOBAL_LOCK) || specExclusiveResources.contains(META_CLASS_REGISTRY_RW)) {
            return true;
        }
        return feature.getExclusiveResources().contains(META_CLASS_REGISTRY_RW);
    }

    private Object createProxyObjectForAbstractGlobalMock(IMockConfiguration configuration, Specification specification, GroovyMockMetaClass mockMetaClass) {
        GroovyMockInterceptor mockInterceptor = new GroovyMockInterceptor(configuration, specification, (MetaClass)mockMetaClass);
        Object proxy = this.createMockObject(configuration, specification, mockInterceptor);
        GroovyRuntimeUtil.setMetaClass(proxy, (MetaClass)mockMetaClass);
        return proxy;
    }

    private Object createMockObject(IMockConfiguration configuration, Specification specification, IProxyBasedMockInterceptor mockInterceptor) {
        MockCreationSettings mockCreationSettings = MockCreationSettings.settingsFromMockConfiguration(configuration, mockInterceptor, specification.getClass().getClassLoader());
        mockCreationSettings.getAdditionalInterface().add(GroovyObject.class);
        return RunContext.get().getMockMakerRegistry().makeMock(mockCreationSettings);
    }

    private boolean isFinalClass(Class<?> type) {
        return !type.isInterface() && Modifier.isFinal(type.getModifiers());
    }

    private boolean isAbstractClass(Class<?> type) {
        return !type.isInterface() && Modifier.isAbstract(type.getModifiers());
    }

    @Override
    public Object createDetached(IMockConfiguration configuration, ClassLoader classLoader) {
        throw new CannotCreateMockException(configuration.getType(), ". Detached mocking is only possible for JavaMocks but not GroovyMocks at the moment.");
    }
}

