/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockController;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.runtime.DynamicMockMethod;
import org.spockframework.mock.runtime.GroovyRealMethodInvoker;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.mock.runtime.SpecificationAttachable;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

public class GroovyMockMetaClass
extends DelegatingMetaClass
implements SpecificationAttachable {
    private final IMockConfiguration configuration;
    private final Specification specification;

    public GroovyMockMetaClass(IMockConfiguration configuration, Specification specification, MetaClass oldMetaClass) {
        super(oldMetaClass);
        this.configuration = configuration;
        this.specification = specification;
    }

    public Object invokeMethod(Object target, String method, Object[] arguments) {
        return this.doInvokeMethod(target, method, arguments, false);
    }

    public Object invokeStaticMethod(Object target, String method, Object[] arguments) {
        return this.doInvokeMethod(target, method, arguments, true);
    }

    public Object invokeConstructor(Object[] arguments) {
        return this.doInvokeMethod(this.configuration.getType(), "<init>", arguments, true);
    }

    public Object getProperty(Object target, String property) {
        String methodName = GroovyRuntimeUtil.propertyToMethodName("is", property);
        MetaMethod metaMethod = this.delegate.getMetaMethod(methodName, GroovyRuntimeUtil.EMPTY_ARGUMENTS);
        if (metaMethod == null || metaMethod.getReturnType() != Boolean.TYPE) {
            methodName = GroovyRuntimeUtil.propertyToMethodName("get", property);
        }
        return this.invokeMethod(target, methodName, GroovyRuntimeUtil.EMPTY_ARGUMENTS);
    }

    public void setProperty(Object target, String property, Object newValue) {
        String methodName = GroovyRuntimeUtil.propertyToMethodName("set", property);
        this.invokeMethod(target, methodName, new Object[]{newValue});
    }

    private Object doInvokeMethod(Object target, String methodName, Object[] arguments, boolean isStatic) {
        Object[] args = GroovyRuntimeUtil.asArgumentArray(arguments);
        if (this.isGetMetaClassCallOnGroovyObject(target, methodName, args, isStatic)) {
            return ((GroovyObject)target).getMetaClass();
        }
        MetaMethod metaMethod = this.delegate.pickMethod(methodName, ReflectionUtil.getTypes(args));
        Method method = GroovyRuntimeUtil.toMethod(metaMethod);
        Object[] unwrappedArgs = GroovyRuntimeUtil.asUnwrappedArgumentArray(args);
        if (method != null && method.getDeclaringClass().isAssignableFrom(this.configuration.getType()) && !isStatic && !ReflectionUtil.isFinalMethod(method) && !this.configuration.isGlobal()) {
            Object[] coercedArgs = metaMethod.coerceArgumentsToClasses(unwrappedArgs);
            return metaMethod.invoke(target, coercedArgs);
        }
        if (metaMethod != null && metaMethod.getDeclaringClass().getTheClass() == GroovyObject.class) {
            if ("invokeMethod".equals(methodName)) {
                return this.invokeMethod(target, (String)unwrappedArgs[0], GroovyRuntimeUtil.asArgumentArray(unwrappedArgs[1]));
            }
            if ("getProperty".equals(methodName)) {
                return this.getProperty(target, (String)unwrappedArgs[0]);
            }
            if ("setProperty".equals(methodName)) {
                this.setProperty(target, (String)unwrappedArgs[0], unwrappedArgs[1]);
                return null;
            }
        }
        IMockInvocation invocation = this.createMockInvocation(metaMethod, target, methodName, args, isStatic);
        IMockController controller = this.specification.getSpecificationContext().getMockController();
        return controller.handle(invocation);
    }

    private boolean isGetMetaClassCallOnGroovyObject(Object target, String method, Object[] arguments, boolean isStatic) {
        return !isStatic && target instanceof GroovyObject && "getMetaClass".equals(method) && arguments.length == 0;
    }

    private IMockInvocation createMockInvocation(MetaMethod metaMethod, Object target, String methodName, Object[] arguments, boolean isStatic) {
        DynamicMockMethod mockMethod;
        MockObject mockObject = new MockObject(this.configuration.getName(), this.configuration.getExactType(), target, this.configuration.isVerified(), this.configuration.isGlobal(), this.configuration.getDefaultResponse(), this.specification, this);
        if (metaMethod != null) {
            List<Type> parameterTypes = Arrays.asList(metaMethod.getNativeParameterTypes());
            mockMethod = new DynamicMockMethod(methodName, parameterTypes, metaMethod.getReturnType(), isStatic);
        } else {
            mockMethod = new DynamicMockMethod(methodName, arguments.length, isStatic);
        }
        return new MockInvocation(mockObject, mockMethod, Arrays.asList(arguments), new GroovyRealMethodInvoker(this.getAdaptee()));
    }

    @Override
    public void attach(Specification specification) {
    }

    @Override
    public void detach() {
    }
}

