/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;
import org.spockframework.util.GenericTypeReflectorUtil;
import spock.mock.IMockMakerSettings;

public class MockConfiguration
implements IMockConfiguration {
    private final String name;
    private final Type type;
    private final Object instance;
    private final MockNature nature;
    private final MockImplementation implementation;
    private final List<Object> constructorArgs;
    private final List<Class<?>> additionalInterfaces;
    private final IDefaultResponse defaultResponse;
    private final boolean global;
    private final boolean verified;
    private final boolean useObjenesis;
    private final IMockMakerSettings mockMakerSettings;

    public MockConfiguration(String name, Type type, MockNature nature, MockImplementation implementation, Map<String, Object> options) {
        this(name, type, null, nature, implementation, options);
    }

    public MockConfiguration(String name, Type type, Object instance, MockNature nature, MockImplementation implementation, Map<String, Object> options) {
        this.name = this.getOption(options, "name", String.class, name);
        this.type = this.getOption(options, "type", Type.class, type);
        this.instance = this.getOption(options, "instance", Object.class, instance);
        this.nature = this.getOption(options, "nature", MockNature.class, nature);
        this.implementation = this.getOption(options, "implementation", MockImplementation.class, implementation);
        this.constructorArgs = this.getOptionAsList(options, "constructorArgs");
        this.additionalInterfaces = this.getOption(options, "additionalInterfaces", List.class, Collections.emptyList());
        this.defaultResponse = this.getOption(options, "defaultResponse", IDefaultResponse.class, this.nature.getDefaultResponse());
        this.global = this.getOption(options, "global", Boolean.class, false);
        this.verified = this.getOption(options, "verified", Boolean.class, this.nature.isVerified());
        this.useObjenesis = this.getOption(options, "useObjenesis", Boolean.class, this.nature.isUseObjenesis());
        this.mockMakerSettings = this.getOption(options, "mockMaker", IMockMakerSettings.class, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return GenericTypeReflectorUtil.erase(this.type);
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public Type getExactType() {
        return this.type;
    }

    @Override
    public MockNature getNature() {
        return this.nature;
    }

    @Override
    public MockImplementation getImplementation() {
        return this.implementation;
    }

    @Override
    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    @Override
    public List<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    @Override
    public IDefaultResponse getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public boolean isUseObjenesis() {
        return this.useObjenesis;
    }

    @Override
    public IMockMakerSettings getMockMaker() {
        return this.mockMakerSettings;
    }

    private <T> T getOption(Map<String, Object> options, String key, Class<T> type, T defaultValue) {
        return options.containsKey(key) ? type.cast(options.get(key)) : defaultValue;
    }

    private List getOptionAsList(Map<String, Object> options, String key) {
        if (options.containsKey(key)) {
            Object obj = options.get(key);
            if (obj instanceof Map) {
                return Collections.singletonList((Map)obj);
            }
            return (List)obj;
        }
        return null;
    }
}

