/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.spockframework.mock.IInteractionAware;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.TooManyInvocationsError;
import org.spockframework.util.TextUtil;

public class MockInteraction
implements IMockInteraction {
    private final int line;
    private final int column;
    private final String text;
    private final int minCount;
    private final int maxCount;
    private final List<IInvocationConstraint> constraints;
    private final IResponseGenerator responseGenerator;
    private final List<IMockInvocation> acceptedInvocations = new ArrayList<IMockInvocation>();

    public MockInteraction(int line, int column, String text, int minCount, int maxCount, List<IInvocationConstraint> constraints, IResponseGenerator responseGenerator) {
        this.line = line;
        this.column = column;
        this.text = text;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.constraints = constraints;
        this.responseGenerator = responseGenerator;
        for (IInvocationConstraint constraint : constraints) {
            if (!(constraint instanceof IInteractionAware)) continue;
            ((IInteractionAware)((Object)constraint)).setInteraction(this);
        }
    }

    @Override
    public boolean matches(IMockInvocation invocation) {
        for (IInvocationConstraint constraint : this.constraints) {
            if (constraint.isSatisfiedBy(invocation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Supplier<Object> accept(IMockInvocation invocation) {
        this.acceptedInvocations.add(invocation);
        if (this.acceptedInvocations.size() > this.maxCount) {
            ArrayList<IMockInvocation> acceptedInvocationsCopy = new ArrayList<IMockInvocation>(this.acceptedInvocations);
            return () -> {
                throw new TooManyInvocationsError(this, acceptedInvocationsCopy);
            };
        }
        return this.responseGenerator == null ? () -> null : this.responseGenerator.getResponseSupplier(invocation);
    }

    @Override
    public List<IMockInvocation> getAcceptedInvocations() {
        return this.acceptedInvocations;
    }

    @Override
    public int computeSimilarityScore(IMockInvocation invocation) {
        int score = 0;
        int weight = this.constraints.size();
        for (IInvocationConstraint constraint : this.constraints) {
            boolean satisfied;
            try {
                satisfied = constraint.isSatisfiedBy(invocation);
            }
            catch (Exception e) {
                satisfied = false;
            }
            if (!satisfied) {
                score += weight;
            }
            --weight;
        }
        return score;
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        ArrayList<String> mismatches = new ArrayList<String>();
        for (IInvocationConstraint constraint : this.constraints) {
            boolean satisfied;
            try {
                satisfied = constraint.isSatisfiedBy(invocation);
            }
            catch (Exception e) {
                satisfied = false;
            }
            if (satisfied) continue;
            mismatches.add(constraint.describeMismatch(invocation));
        }
        return TextUtil.join("\n", mismatches);
    }

    @Override
    public boolean isSatisfied() {
        return this.acceptedInvocations.size() >= this.minCount;
    }

    @Override
    public boolean isExhausted() {
        return this.acceptedInvocations.size() >= this.maxCount;
    }

    @Override
    public boolean isRequired() {
        return this.minCount != 0 || this.maxCount != Integer.MAX_VALUE;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.format("%s   (%d %s)", this.text, this.acceptedInvocations.size(), this.acceptedInvocations.size() == 1 ? "invocation" : "invocations");
    }
}

