/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Type;
import org.spockframework.lang.Wildcard;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.runtime.SpecificationAttachable;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.util.GenericTypeReflectorUtil;
import spock.lang.Specification;

public class MockObject
implements IMockObject {
    private final String name;
    private final Type type;
    private final Object instance;
    private final boolean verified;
    private final boolean global;
    private final IDefaultResponse defaultResponse;
    private final SpecificationAttachable mockInterceptor;
    private Specification specification;

    public MockObject(String name, Type type, Object instance, boolean verified, boolean global, IDefaultResponse defaultResponse, Specification specification, SpecificationAttachable mockInterceptor) {
        this.name = name;
        this.type = type;
        this.instance = instance;
        this.verified = verified;
        this.global = global;
        this.defaultResponse = defaultResponse;
        this.specification = specification;
        this.mockInterceptor = mockInterceptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return GenericTypeReflectorUtil.erase(this.type);
    }

    @Override
    public Type getExactType() {
        return this.type;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public IDefaultResponse getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public boolean matches(Object target, IMockInteraction interaction) {
        boolean match;
        if (target instanceof Wildcard) {
            return this.verified || !interaction.isRequired();
        }
        boolean bl = this.global ? this.matchGlobal(target) : (match = this.instance == target);
        if (match) {
            this.checkRequiredInteractionAllowed(interaction);
        }
        return match;
    }

    private boolean matchGlobal(Object target) {
        return this.instance.getClass() == target.getClass() && (!this.isMockOfClass() || this.instance == target);
    }

    private boolean isMockOfClass() {
        return this.instance instanceof Class;
    }

    private void checkRequiredInteractionAllowed(IMockInteraction interaction) {
        if (!this.verified && interaction.isRequired()) {
            String mockName = this.name != null ? this.name : "unnamed";
            throw new InvalidSpecException("Stub '%s' matches the following required interaction:\n\n%s\n\nRemove the cardinality (e.g. '1 *'), or turn the stub into a mock.\n").withArgs(mockName, interaction);
        }
    }

    @Override
    public void attach(Specification spec) {
        this.specification = spec;
        this.mockInterceptor.attach(spec);
    }

    @Override
    public void detach() {
        this.specification = null;
        this.mockInterceptor.detach();
    }
}

