/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.spockframework.mock.IMockMethod;
import org.spockframework.util.GenericTypeReflectorUtil;
import org.spockframework.util.ReflectionUtil;

public class StaticMockMethod
implements IMockMethod {
    private final Method method;
    private final Type mockType;

    public StaticMockMethod(Method method, Type mockType) {
        this.method = method;
        this.mockType = StaticMockMethod.isMethodFromAdditionalInterfaces(mockType, method) ? method.getDeclaringClass() : mockType;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return ReflectionUtil.eraseTypes(this.getExactParameterTypes());
    }

    @Override
    public List<Type> getExactParameterTypes() {
        return Arrays.asList(GenericTypeReflectorUtil.getParameterTypes(this.method, this.mockType));
    }

    @Override
    public Class<?> getReturnType() {
        return GenericTypeReflectorUtil.erase(this.getExactReturnType());
    }

    @Override
    public Type getExactReturnType() {
        return GenericTypeReflectorUtil.getReturnType(this.method, this.mockType);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    private static boolean isMethodFromAdditionalInterfaces(Type mockType, Method method) {
        return GenericTypeReflectorUtil.getExactSuperType(mockType, method.getDeclaringClass()) == null;
    }
}

