/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime.mockito;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.mockito.MockitoMockMakerImpl;
import org.spockframework.util.ReflectionUtil;
import spock.mock.MockMakerId;

public class MockitoMockMaker
implements IMockMaker {
    public static final MockMakerId ID = new MockMakerId("mockito");
    private static final boolean mockitoAvailable = ReflectionUtil.isClassAvailable("org.mockito.Mockito");
    private static final Set<IMockMaker.MockMakerCapability> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(IMockMaker.MockMakerCapability.INTERFACE, new IMockMaker.MockMakerCapability[]{IMockMaker.MockMakerCapability.CLASS, IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES, IMockMaker.MockMakerCapability.EXPLICIT_CONSTRUCTOR_ARGUMENTS, IMockMaker.MockMakerCapability.FINAL_CLASS, IMockMaker.MockMakerCapability.FINAL_METHOD, IMockMaker.MockMakerCapability.STATIC_METHOD}));
    private final MockitoMockMakerImpl impl = mockitoAvailable ? new MockitoMockMakerImpl() : null;

    @Override
    public MockMakerId getId() {
        return ID;
    }

    @Override
    public Set<IMockMaker.MockMakerCapability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getPriority() {
        return 400;
    }

    @Override
    public IMockObject asMockOrNull(Object object) {
        if (this.impl == null) {
            return null;
        }
        return this.impl.asMockOrNull(object);
    }

    @Override
    public Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        return Objects.requireNonNull(this.impl).makeMock(settings);
    }

    @Override
    public IMockMaker.IStaticMock makeStaticMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        return Objects.requireNonNull(this.impl).makeStaticMock(settings);
    }

    @Override
    public boolean isStaticMock(Class<?> clazz) {
        return Objects.requireNonNull(this.impl).isStaticMock(clazz);
    }

    @Override
    public IMockMaker.IMockabilityResult getMockability(IMockMaker.IMockCreationSettings settings) {
        Class<?> mockType = settings.getMockType();
        if (Modifier.isFinal(mockType.getModifiers()) && !settings.getAdditionalInterface().isEmpty()) {
            return () -> "Cannot mock final classes with additional interfaces.";
        }
        if (!mockitoAvailable) {
            return () -> "The mockito-core library >= 4.11 is missing on the class path.";
        }
        return Objects.requireNonNull(this.impl).isMockable(settings.getMockType());
    }
}

