/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime.mockito;

import groovy.lang.Closure;
import java.util.Objects;
import org.mockito.MockSettings;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.ObjectUtil;
import spock.mock.IMockMakerSettings;
import spock.mock.MockMakerId;
import spock.mock.MockMakers;

public final class MockitoMockMakerSettings
implements IMockMakerSettings {
    private final Closure<?> mockitoCode;

    public static MockitoMockMakerSettings createSettings(Closure<?> mockitoCode) {
        return new MockitoMockMakerSettings(mockitoCode);
    }

    private MockitoMockMakerSettings(Closure<?> mockitoCode) {
        this.mockitoCode = Objects.requireNonNull(mockitoCode);
    }

    @Override
    public MockMakerId getMockMakerId() {
        return MockMakers.mockito.getMockMakerId();
    }

    void applySettings(MockSettings mockitoSettings) {
        Objects.requireNonNull(mockitoSettings);
        Closure mockitoCode = (Closure)ObjectUtil.uncheckedCast(this.mockitoCode.clone());
        mockitoCode.setResolveStrategy(1);
        mockitoCode.setDelegate((Object)mockitoSettings);
        GroovyRuntimeUtil.invokeClosure(mockitoCode, mockitoSettings);
    }

    public String toString() {
        return this.getMockMakerId() + " mock maker settings";
    }
}

