/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.IDataIterator;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.DataProcessorMetadata;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class DataIteratorFactory {
    protected final IRunSupervisor supervisor;

    public DataIteratorFactory(IRunSupervisor supervisor) {
        this.supervisor = supervisor;
    }

    public IDataIterator createFeatureDataIterator(SpockExecutionContext context) {
        if (context.getCurrentFeature().getDataProcessorMethod() == null) {
            return new SingleEmptyIterationDataIterator();
        }
        return new DataProcessorIterator(this.supervisor, context, new FeatureDataProviderIterator(this.supervisor, context));
    }

    private static class FeatureDataProviderIterator
    extends BaseDataIterator {
        private final Object[] dataProviders;
        private final Iterator<?>[] iterators;
        private final int estimatedNumIterations;
        private final List<String> dataVariableNames = this.dataVariableNames();
        private int iteration = 0;

        public FeatureDataProviderIterator(IRunSupervisor supervisor, SpockExecutionContext context) {
            super(supervisor, context);
            this.dataProviders = this.createDataProviders();
            this.estimatedNumIterations = this.estimateNumIterations();
            this.iterators = this.createIterators();
        }

        @Override
        public void close() {
            if (this.dataProviders == null) {
                return;
            }
            for (Object provider : this.dataProviders) {
                GroovyRuntimeUtil.invokeMethodQuietly(provider, "close", new Object[0]);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return false;
            }
            if (this.iterators.length == 0 && this.iteration > 0) {
                return false;
            }
            boolean haveNext = true;
            for (int i = 0; i < this.iterators.length; ++i) {
                try {
                    boolean hasNext = this.iterators[i].hasNext();
                    if (i == 0) {
                        haveNext = hasNext;
                        continue;
                    }
                    if (haveNext == hasNext) continue;
                    DataProviderInfo provider = this.context.getCurrentFeature().getDataProviders().get(i);
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(provider.getDataProviderMethod(), this.createDifferentNumberOfDataValuesException(provider, hasNext)));
                    return false;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                    return false;
                }
            }
            return haveNext;
        }

        @Override
        public Object[] next() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            ++this.iteration;
            Object[] next = new Object[this.iterators.length];
            for (int i = 0; i < this.iterators.length; ++i) {
                try {
                    next[i] = this.iterators[i].next();
                    continue;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                    return null;
                }
            }
            return next;
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.estimatedNumIterations;
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        private int estimateNumIterations() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return -1;
            }
            if (this.dataProviders.length == 0) {
                return 1;
            }
            int result = Integer.MAX_VALUE;
            for (Object prov : this.dataProviders) {
                int size;
                Object rawSize;
                if (prov instanceof Iterator || !((rawSize = GroovyRuntimeUtil.invokeMethodQuietly(prov, "size", new Object[0])) instanceof Number) || (size = ((Number)rawSize).intValue()) < 0 || size >= result) continue;
                result = size;
            }
            return result == Integer.MAX_VALUE ? -1 : result;
        }

        private Object[] createDataProviders() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            List<DataProviderInfo> dataProviderInfos = this.context.getCurrentFeature().getDataProviders();
            if (dataProviderInfos.isEmpty()) {
                return new Object[0];
            }
            Object[] dataProviders = new Object[dataProviderInfos.size()];
            int size = dataProviderInfos.size();
            for (int i = 0; i < size; ++i) {
                DataProviderInfo dataProviderInfo = dataProviderInfos.get(i);
                MethodInfo method = dataProviderInfo.getDataProviderMethod();
                Object provider = this.invokeRaw(this.context.getCurrentInstance(), method, this.getPreviousDataTableProviders(this.dataVariableNames, dataProviders, dataProviderInfo));
                if (this.context.getErrorInfoCollector().hasErrors()) {
                    if (provider == null) break;
                    dataProviders[i] = provider;
                    break;
                }
                if (provider == null) {
                    SpockExecutionException error = new SpockExecutionException("Data provider is null!");
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(method, error));
                    break;
                }
                dataProviders[i] = provider;
            }
            return dataProviders;
        }

        @NotNull
        private List<String> dataVariableNames() {
            return this.context.getCurrentFeature().getDataProviders().stream().map(DataProviderInfo::getDataVariables).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Object[] getPreviousDataTableProviders(List<String> dataProviderVariables, Object[] dataProviders, DataProviderInfo dataProviderInfo) {
            ArrayList<Object> result = new ArrayList<Object>();
            block0: for (String previousDataTableVariable : dataProviderInfo.getPreviousDataTableVariables()) {
                int size = dataProviderVariables.size();
                for (int i = 0; i < size; ++i) {
                    String dataProviderVariable = dataProviderVariables.get(i);
                    if (!previousDataTableVariable.equals(dataProviderVariable)) continue;
                    result.add(dataProviders[i]);
                    continue block0;
                }
                throw new IllegalStateException(String.format("Variable name not defined (%s not in %s)!", previousDataTableVariable, dataProviderVariables));
            }
            return result.toArray();
        }

        private Iterator<?>[] createIterators() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            Iterator[] iterators = new Iterator[this.dataProviders.length];
            for (int i = 0; i < this.dataProviders.length; ++i) {
                try {
                    Iterator<Object> iter = GroovyRuntimeUtil.asIterator(this.dataProviders[i]);
                    if (iter == null) {
                        this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), new SpockExecutionException("Data provider's iterator() method returned null")));
                        return null;
                    }
                    iterators[i] = iter;
                    continue;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                    return null;
                }
            }
            return iterators;
        }

        private SpockExecutionException createDifferentNumberOfDataValuesException(DataProviderInfo provider, boolean hasNext) {
            String msg = String.format("Data provider for variable '%s' has %s values than previous data provider(s)", provider.getDataVariables().get(0), hasNext ? "more" : "fewer");
            SpockExecutionException exception = new SpockExecutionException(msg);
            FeatureInfo feature = (FeatureInfo)provider.getParent();
            SpecInfo spec = (SpecInfo)feature.getParent();
            StackTraceElement elem = new StackTraceElement(((Class)spec.getReflection()).getName(), feature.getName(), spec.getFilename(), provider.getLine());
            exception.setStackTrace(new StackTraceElement[]{elem});
            return exception;
        }
    }

    private static class DataProcessorIterator
    extends BaseDataIterator {
        private final IDataIterator delegate;
        private final List<String> dataVariableNames;

        private DataProcessorIterator(IRunSupervisor supervisor, SpockExecutionContext context, IDataIterator delegate) {
            super(supervisor, context);
            this.delegate = delegate;
            this.dataVariableNames = this.readDataVariableNames();
        }

        @NotNull
        private List<String> readDataVariableNames() {
            return Collections.unmodifiableList(Arrays.asList(this.context.getCurrentFeature().getDataProcessorMethod().getAnnotation(DataProcessorMetadata.class).dataVariables()));
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.delegate.getEstimatedNumIterations();
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object[] next() {
            Object[] next = (Object[])this.delegate.next();
            if (next == null) {
                return null;
            }
            try {
                return (Object[])this.invokeRaw(this.context.getSharedInstance(), this.context.getCurrentFeature().getDataProcessorMethod(), next);
            }
            catch (Throwable t) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProcessorMethod(), t));
                return null;
            }
        }
    }

    private static class SingleEmptyIterationDataIterator
    implements IDataIterator {
        public static final List<Object[]> DEFAULT_PARAMS = Collections.singletonList(new Object[0]);
        private final Iterator<Object[]> delegate = DEFAULT_PARAMS.iterator();

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object[] next() {
            return this.delegate.next();
        }

        @Override
        public int getEstimatedNumIterations() {
            return 1;
        }

        @Override
        public List<String> getDataVariableNames() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws Exception {
        }
    }

    private static abstract class BaseDataIterator
    implements IDataIterator {
        protected final IRunSupervisor supervisor;
        protected final SpockExecutionContext context;

        public BaseDataIterator(IRunSupervisor supervisor, SpockExecutionContext context) {
            this.supervisor = supervisor;
            this.context = context;
        }

        protected Object invokeRaw(Object target, MethodInfo method, Object ... arguments) {
            try {
                return method.invoke(target, arguments);
            }
            catch (Throwable throwable) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(method, throwable));
                return null;
            }
        }
    }
}

