/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spockframework.runtime.IConfigurationRegistry;
import org.spockframework.runtime.IExtensionRegistry;
import org.spockframework.runtime.extension.ExtensionAnnotation;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.RepeatedExtensionAnnotations;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Pair;

public class ExtensionRunner {
    private final SpecInfo spec;
    private final IExtensionRegistry extensionRegistry;
    private final IConfigurationRegistry configurationRegistry;
    private final Map<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension> localExtensions = new HashMap<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension>();

    public ExtensionRunner(SpecInfo spec, IExtensionRegistry extensionRegistry, IConfigurationRegistry configurationRegistry) {
        this.spec = spec;
        this.extensionRegistry = extensionRegistry;
        this.configurationRegistry = configurationRegistry;
    }

    public void run() {
        this.runGlobalExtensions();
        this.runAnnotationDrivenExtensions();
    }

    private void runGlobalExtensions() {
        for (IGlobalExtension extension : this.extensionRegistry.getGlobalExtensions()) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions() {
        this.runAnnotationDrivenExtensions(this.spec);
        for (IAnnotationDrivenExtension extension : this.localExtensions.values()) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.runAnnotationDrivenExtensions(spec.getSuperSpec());
        this.doRunAnnotationDrivenExtensions(spec);
        for (FieldInfo field : spec.getFields()) {
            this.doRunAnnotationDrivenExtensions(field);
        }
        this.doRunAnnotationDrivenExtensions(spec.getSetupSpecMethods());
        this.doRunAnnotationDrivenExtensions(spec.getSetupMethods());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupMethods());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupSpecMethods());
        for (FeatureInfo feature : spec.getFeatures()) {
            this.doRunAnnotationDrivenExtensions(feature.getFeatureMethod());
        }
    }

    private void doRunAnnotationDrivenExtensions(Iterable<MethodInfo> nodes) {
        for (MethodInfo node : nodes) {
            this.doRunAnnotationDrivenExtensions(node);
        }
    }

    private void doRunAnnotationDrivenExtensions(NodeInfo<?, ?> node) {
        ArrayList<List<Annotation>> annotations;
        RepeatedExtensionAnnotations repeatedExtensionAnnotations = node.getAnnotation(RepeatedExtensionAnnotations.class);
        if (repeatedExtensionAnnotations == null) {
            annotations = Arrays.stream(node.getAnnotations()).map(Collections::singletonList).collect(Collectors.toList());
        } else {
            annotations = new ArrayList();
            List<Class<? extends Annotation>> repeatedAnnotations = Arrays.asList(repeatedExtensionAnnotations.value());
            Arrays.stream(node.getAnnotations()).filter(annotation -> repeatedAnnotations.stream().noneMatch(repeatedAnnotation -> repeatedAnnotation.isInstance(annotation))).map(Collections::singletonList).forEach(annotations::add);
            for (Class<? extends Annotation> repeatedAnnotation : repeatedAnnotations) {
                annotations.add(Arrays.asList(node.getAnnotationsByType(repeatedAnnotation)));
            }
        }
        this.doRunAnnotationDrivenExtensions(node, annotations);
        this.doRunAnnotationDrivenExtensionsForParameters(node);
    }

    private void doRunAnnotationDrivenExtensionsForParameters(NodeInfo<?, ?> node) {
        if (node instanceof MethodInfo) {
            MethodInfo method = (MethodInfo)node;
            method.getParameters().forEach(parameterInfo -> Arrays.stream(parameterInfo.getAnnotations()).map(ann -> Pair.of(ann, this.getAnnotationDrivenExtension((Annotation)ann))).filter(annEx -> annEx.second() != null).forEach(annEx -> ((IAnnotationDrivenExtension)annEx.second()).visitParameterAnnotation((Annotation)annEx.first(), (ParameterInfo)parameterInfo)));
        }
    }

    private void doRunAnnotationDrivenExtensions(NodeInfo<?, ?> node, List<List<Annotation>> annotations) {
        for (List<Annotation> ann : annotations) {
            IAnnotationDrivenExtension extension = this.getAnnotationDrivenExtension(ann.get(0));
            if (extension == null) continue;
            if (node instanceof SpecInfo) {
                extension.visitSpecAnnotations(ann, (SpecInfo)node);
                continue;
            }
            if (node instanceof MethodInfo) {
                MethodInfo method = (MethodInfo)node;
                if (method.getKind() == MethodKind.FEATURE) {
                    extension.visitFeatureAnnotations(ann, method.getFeature());
                    continue;
                }
                extension.visitFixtureAnnotations(ann, method);
                continue;
            }
            extension.visitFieldAnnotations(ann, (FieldInfo)node);
        }
    }

    private IAnnotationDrivenExtension getAnnotationDrivenExtension(Annotation annotation) {
        ExtensionAnnotation extAnn = annotation.annotationType().getAnnotation(ExtensionAnnotation.class);
        if (extAnn == null) {
            return null;
        }
        return this.getOrCreateExtension(extAnn.value());
    }

    private IAnnotationDrivenExtension getOrCreateExtension(Class<? extends IAnnotationDrivenExtension> clazz) {
        return this.localExtensions.computeIfAbsent(clazz, this.configurationRegistry::instantiateExtension);
    }
}

