/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.IConfigurationRegistry;
import org.spockframework.runtime.IExtensionRegistry;
import org.spockframework.runtime.SpockExecution;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.ISpockExecution;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.UnreachableCodeError;
import spock.config.ConfigurationObject;

public class GlobalExtensionRegistry
implements IExtensionRegistry,
IConfigurationRegistry {
    private final List<Class<? extends IGlobalExtension>> globalExtensionClasses;
    private final Map<Class<?>, Object> configurationsByType = new HashMap();
    private final Map<String, Object> configurationsByName = new HashMap<String, Object>();
    private final List<IGlobalExtension> globalExtensions = new ArrayList<IGlobalExtension>();

    GlobalExtensionRegistry(List<Class<? extends IGlobalExtension>> globalExtensionClasses, List<Class<?>> initialConfigurations) {
        this.globalExtensionClasses = globalExtensionClasses;
        this.initializeConfigurations(initialConfigurations);
    }

    private void initializeConfigurations(List<Class<?>> initialConfigurations) {
        for (Class<?> configuration : initialConfigurations) {
            ConfigurationObject annotation = configuration.getAnnotation(ConfigurationObject.class);
            if (annotation == null) {
                throw new InternalSpockError("Not a @ConfigurationObject: %s").withArgs(configuration);
            }
            this.createAndStoreConfiguration(configuration, annotation);
        }
    }

    public void initializeGlobalExtensions() {
        for (Class<? extends IGlobalExtension> clazz : this.globalExtensionClasses) {
            this.verifyGlobalExtension(clazz);
            IGlobalExtension extension = this.instantiateAndConfigureExtension(clazz);
            this.globalExtensions.add(extension);
        }
    }

    @Override
    public <T> T getConfigurationByType(Class<T> clazz) {
        return clazz.cast(this.configurationsByType.get(clazz));
    }

    @Override
    public Object getConfigurationByName(String name) {
        return this.configurationsByName.get(name);
    }

    @Override
    public List<IGlobalExtension> getGlobalExtensions() {
        return this.globalExtensions;
    }

    private void verifyGlobalExtension(Class<?> clazz) {
        if (!IGlobalExtension.class.isAssignableFrom(clazz)) {
            throw new ExtensionException("Class '%s' is not a valid global extension because it is not derived from '%s'").withArgs(clazz.getName(), IGlobalExtension.class.getName());
        }
    }

    private <T> T instantiateAndConfigureExtension(Class<T> clazz) {
        try {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            Constructor<?> declaredConstructor = this.findBestFittingConstructor(declaredConstructors);
            if (declaredConstructor.getParameterCount() == 0) {
                Object extension = declaredConstructor.newInstance(new Object[0]);
                this.configureExtension(extension);
                return clazz.cast(extension);
            }
            Object[] args = Arrays.stream(declaredConstructor.getParameters()).map(parameter -> this.getInjectionParameter((Parameter)parameter, clazz)).toArray();
            return clazz.cast(declaredConstructor.newInstance(args));
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate extension '%s'", e).withArgs(clazz.getName());
        }
    }

    private Constructor<?> findBestFittingConstructor(Constructor<?>[] declaredConstructors) {
        return Arrays.stream(declaredConstructors).filter(constructor -> Arrays.stream(constructor.getParameterTypes()).allMatch(this::isInjectable)).max(Comparator.comparing(Constructor::getParameterCount)).orElseThrow(() -> new ExtensionException("No suitable constructor found, only injectable parameters are permissible."));
    }

    private boolean isInjectable(Class<?> aClass) {
        ConfigurationObject annotation = aClass.getAnnotation(ConfigurationObject.class);
        return annotation != null;
    }

    @Override
    public <T> T instantiateExtension(Class<T> extension) {
        return this.instantiateAndConfigureExtension(extension);
    }

    private void configureExtension(Object extension) {
        Arrays.stream(extension.getClass().getDeclaredFields()).filter(field -> !Modifier.isFinal(field.getModifiers())).forEach(field -> {
            ConfigurationObject annotation = field.getType().getAnnotation(ConfigurationObject.class);
            if (annotation != null) {
                this.injectConfiguration((Field)field, annotation, extension);
            }
        });
    }

    public void startGlobalExtensions() {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.start();
        }
    }

    public void startExecutionForGlobalExtensions(ISpockExecution spockExecution) {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.executionStart(spockExecution);
        }
    }

    public void stopExecutionForGlobalExtensions(SpockExecution spockExecution) {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.executionStop(spockExecution);
        }
    }

    public void stopGlobalExtensions() {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.stop();
        }
    }

    private void injectConfiguration(Field field, ConfigurationObject annotation, Object extension) {
        Object config = this.getOrCreateConfig(field.getType(), annotation, extension.getClass());
        field.setAccessible(true);
        try {
            field.set(extension, config);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableCodeError();
        }
    }

    @NotNull
    private Object getOrCreateConfig(Class<?> configType, ConfigurationObject annotation, Class<?> extensionClass) {
        Object config;
        if (IGlobalExtension.class.isAssignableFrom(extensionClass)) {
            config = this.getOrCreateConfiguration(configType, annotation);
        } else {
            config = this.getConfigurationByType(configType);
            if (config == null) {
                throw new ExtensionException("Extension '%s' references unknown configuration class '%s'").withArgs(extensionClass, configType);
            }
        }
        return config;
    }

    private Object getInjectionParameter(Parameter parameter, Class<?> extensionClass) {
        ConfigurationObject annotation = parameter.getType().getAnnotation(ConfigurationObject.class);
        return this.getOrCreateConfig(parameter.getType(), annotation, extensionClass);
    }

    private Object getOrCreateConfiguration(Class<?> type, ConfigurationObject annotation) {
        Object config = this.getConfigurationByType(type);
        if (config == null) {
            config = this.createAndStoreConfiguration(type, annotation);
        }
        return config;
    }

    private Object createAndStoreConfiguration(Class<?> configuration, ConfigurationObject annotation) {
        Object instance = this.createConfiguration(configuration);
        this.configurationsByType.put(configuration, instance);
        this.configurationsByName.put(annotation.value(), instance);
        return instance;
    }

    @NotNull
    private Object createConfiguration(Class<?> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ExtensionException("Cannot instantiate configuration class %s", e).withArgs(type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExtensionException("Configuration class '%s' has no public no-arg constructor", e).withArgs(type);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate configuration '%s'", e).withArgs(type.getName());
        }
    }
}

