/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.FeatureNode;
import org.spockframework.runtime.ParameterizedFeatureChildExecutor;
import org.spockframework.runtime.SafeIterationNameProvider;
import org.spockframework.runtime.SpockAssertionError;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.util.ExceptionUtil;
import spock.config.RunnerConfiguration;

public class ParameterizedFeatureNode
extends FeatureNode {
    protected ParameterizedFeatureNode(UniqueId uniqueId, RunnerConfiguration configuration, FeatureInfo featureInfo) {
        super(uniqueId, featureInfo.getDisplayName(), (TestSource)ParameterizedFeatureNode.featureToMethodSource(featureInfo), configuration, featureInfo);
    }

    @Override
    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        if (((FeatureInfo)this.getNodeInfo()).isSkipped()) {
            return context;
        }
        ((FeatureInfo)this.getNodeInfo()).setIterationNameProvider(new SafeIterationNameProvider(((FeatureInfo)this.getNodeInfo()).getIterationNameProvider()));
        return super.prepare(context).withCurrentFeature((FeatureInfo)this.getNodeInfo()).withParentId(this.getUniqueId());
    }

    public SpockExecutionContext execute(SpockExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        this.verifyNotSkipped((ISkippable)this.getNodeInfo());
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        ParameterizedFeatureChildExecutor childExecutor = new ParameterizedFeatureChildExecutor(this, dynamicTestExecutor, context.getEngineExecutionListener());
        context.getRunner().runParameterizedFeature(context, childExecutor);
        errorInfoCollector.assertEmpty();
        if (childExecutor.getExecutionCount() < 1) {
            throw new SpockExecutionException("Data provider has no data");
        }
        if (((FeatureInfo)this.getNodeInfo()).isReportIterations()) {
            return context;
        }
        Map<TestExecutionResult.Status, Queue<Throwable>> childResults = childExecutor.getResults();
        if (childResults.containsKey(TestExecutionResult.Status.FAILED)) {
            this.handleFailedChildren(childResults);
        } else if (!childResults.containsKey(TestExecutionResult.Status.SUCCESSFUL)) {
            this.handleOnlyAbortedChildren(childResults);
        }
        return context;
    }

    private void handleFailedChildren(Map<TestExecutionResult.Status, Queue<Throwable>> childResults) {
        if (!childResults.containsKey(TestExecutionResult.Status.FAILED)) {
            throw new AssertionError((Object)"This method should only be called if there are aborted children and nothing else");
        }
        List failures = childResults.get(TestExecutionResult.Status.FAILED).stream().filter(Objects::nonNull).collect(Collectors.toList());
        switch (failures.size()) {
            case 0: {
                throw new SpockAssertionError("At least one iteration failed");
            }
            case 1: {
                ExceptionUtil.sneakyThrow((Throwable)failures.get(0));
            }
        }
        MultipleFailuresError multipleFailuresError = new MultipleFailuresError(null, failures);
        multipleFailuresError.setStackTrace(((Throwable)failures.get(0)).getStackTrace());
        throw multipleFailuresError;
    }

    private void handleOnlyAbortedChildren(Map<TestExecutionResult.Status, Queue<Throwable>> childResults) {
        Object testAbortedException;
        Object abortion;
        if (childResults.size() != 1 || !childResults.containsKey(TestExecutionResult.Status.ABORTED)) {
            throw new AssertionError((Object)"This method should only be called if there are aborted children and nothing else");
        }
        List abortions = childResults.get(TestExecutionResult.Status.ABORTED).stream().filter(Objects::nonNull).collect(Collectors.toList());
        switch (abortions.size()) {
            case 0: {
                abortion = new TestAbortedException("All iterations were aborted");
                break;
            }
            case 1: {
                abortion = (Throwable)abortions.get(0);
                break;
            }
            default: {
                abortion = new MultipleFailuresError(null, abortions);
                ((Throwable)abortion).setStackTrace(((Throwable)abortions.get(0)).getStackTrace());
            }
        }
        if (abortion instanceof TestAbortedException) {
            testAbortedException = abortion;
        } else {
            testAbortedException = new TestAbortedException("All iterations were aborted", (Throwable)abortion);
            testAbortedException.setStackTrace(((Throwable)abortion).getStackTrace());
        }
        throw testAbortedException;
    }

    @Override
    public TestDescriptor.Type getType() {
        return ((FeatureInfo)this.getNodeInfo()).isReportIterations() ? TestDescriptor.Type.CONTAINER_AND_TEST : TestDescriptor.Type.TEST;
    }
}

