/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.ParameterizedFeatureChildExecutor;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.extension.MethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

public class PlatformSpecRunner {
    protected final IRunSupervisor supervisor;

    public PlatformSpecRunner(IRunSupervisor supervisor) {
        this.supervisor = supervisor;
    }

    SpockExecutionContext runSharedSpec(SpockExecutionContext context) {
        context = this.createSpecInstance(context, true);
        this.runSharedInitializer(context);
        return context;
    }

    public void runSpec(SpockExecutionContext context, Runnable specRunner) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        SpecInfo spec = context.getSpec();
        this.supervisor.beforeSpec(spec);
        this.invoke(context, this, this.createMethodInfoForDoRunSpec(context, specRunner), new Object[0]);
        this.supervisor.afterSpec(spec);
        this.runCloseContextStoreProvider(context, MethodKind.CLEANUP_SPEC);
    }

    private MethodInfo createMethodInfoForDoRunSpec(SpockExecutionContext context, Runnable specRunner) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            specRunner.run();
            return null;
        });
        SpecInfo spec = context.getSpec();
        result.setParent(spec);
        result.setKind(MethodKind.SPEC_EXECUTION);
        spec.getInterceptors().forEach(result::addInterceptor);
        return result;
    }

    SpockExecutionContext createSpecInstance(SpockExecutionContext context, boolean shared) {
        Specification instance;
        if (context.getErrorInfoCollector().hasErrors()) {
            return context;
        }
        try {
            instance = (Specification)((Class)context.getSpec().getReflection()).newInstance();
        }
        catch (Throwable t) {
            throw new InternalSpockError("Failed to instantiate spec '%s'", t).withArgs(context.getSpec().getName());
        }
        context = context.withChildStoreProvider().withCurrentInstance(instance);
        this.getSpecificationContext(context).setCurrentSpec(context.getSpec());
        if (shared) {
            context = context.withSharedInstance(instance);
        }
        this.getSpecificationContext(context).setSharedInstance(context.getSharedInstance());
        return context;
    }

    private void runSharedInitializer(SpockExecutionContext context) {
        this.runSharedInitializer(context, context.getSpec());
    }

    private void runSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSharedInitializer(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSharedInitializer(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.SHARED_INITIALIZER);
        spec.getSharedInitializerInterceptors().forEach(result::addInterceptor);
        return result;
    }

    public void doRunSharedInitializer(SpockExecutionContext context, SpecInfo spec) {
        this.runSharedInitializer(context, spec.getSuperSpec());
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        this.invoke(context, context.getCurrentInstance(), spec.getSharedInitializerMethod(), new Object[0]);
    }

    void runSetupSpec(SpockExecutionContext context) {
        this.runSetupSpec(context, context.getSpec());
    }

    private void runSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSetupSpec(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSetupSpec(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.SETUP_SPEC);
        spec.getSetupSpecInterceptors().forEach(result::addInterceptor);
        return result;
    }

    public void doRunSetupSpec(SpockExecutionContext context, SpecInfo spec) {
        this.runSetupSpec(context, spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupSpecMethods()) {
            if (context.getErrorInfoCollector().hasErrors()) {
                return;
            }
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
    }

    void runCleanupSpec(SpockExecutionContext context) {
        this.runCleanupSpec(context.withCurrentInstance(context.getSharedInstance()), context.getSpec());
    }

    private void runCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodForDoRunCleanupSpec(context, spec), spec);
    }

    private MethodInfo createMethodForDoRunCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunCleanupSpec(context, spec);
            return null;
        });
        result.setParent(spec);
        result.setKind(MethodKind.CLEANUP_SPEC);
        spec.getCleanupSpecInterceptors().forEach(result::addInterceptor);
        return result;
    }

    public void doRunCleanupSpec(SpockExecutionContext context, SpecInfo spec) {
        for (MethodInfo method : spec.getCleanupSpecMethods()) {
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
        this.runCleanupSpec(context, spec.getSuperSpec());
    }

    public void runFeature(SpockExecutionContext context, Runnable feature) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        FeatureInfo currentFeature = context.getCurrentFeature();
        if (currentFeature.isExcluded()) {
            return;
        }
        if (currentFeature.isSkipped()) {
            throw new InternalSpockError("Invalid state, feature is executed although it should have been skipped");
        }
        this.getSpecificationContext(context).setCurrentFeature(currentFeature);
        this.supervisor.beforeFeature(currentFeature);
        this.invoke(context, this, this.createMethodInfoForDoRunFeature(context, feature), new Object[0]);
        this.supervisor.afterFeature(currentFeature);
        this.runCloseContextStoreProvider(context, MethodKind.CLEANUP);
        this.getSpecificationContext(context).setCurrentFeature(null);
    }

    private MethodInfo createMethodInfoForDoRunFeature(SpockExecutionContext context, Runnable feature) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            feature.run();
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.FEATURE_EXECUTION);
        result.setFeature(currentFeature);
        currentFeature.getInterceptors().forEach(result::addInterceptor);
        return result;
    }

    void runIteration(SpockExecutionContext context, IterationInfo iterationInfo, Runnable runnable) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        context = context.withCurrentIteration(iterationInfo);
        this.getSpecificationContext(context).setCurrentIteration(iterationInfo);
        this.supervisor.beforeIteration(iterationInfo);
        this.invoke(context, this, this.createMethodInfoForDoRunIteration(context, runnable), new Object[0]);
        this.supervisor.afterIteration(iterationInfo);
        this.runCloseContextStoreProvider(context, MethodKind.CLEANUP);
        this.getSpecificationContext(context).setCurrentIteration(null);
    }

    IterationInfo createIterationInfo(SpockExecutionContext context, int iterationIndex, Object[] args, int estimatedNumIterations) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        Object[] dataValues = Arrays.copyOfRange(args, 0, currentFeature.getDataVariables().size());
        IterationInfo result = new IterationInfo(currentFeature, iterationIndex, dataValues, estimatedNumIterations);
        result.setName(currentFeature.getName());
        String iterationName = currentFeature.getIterationNameProvider().getName(result);
        result.setDisplayName(iterationName);
        return result;
    }

    private MethodInfo createMethodInfoForDoRunIteration(SpockExecutionContext context, Runnable runnable) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            runnable.run();
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.ITERATION_EXECUTION);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        currentFeature.getIterationInterceptors().forEach(result::addInterceptor);
        return result;
    }

    void runParameterizedFeature(SpockExecutionContext context, ParameterizedFeatureChildExecutor childExecutor) throws InterruptedException {
        throw new UnsupportedOperationException("This runner cannot run parameterized features");
    }

    void runInitializer(SpockExecutionContext context) {
        this.getSpecificationContext(context).setCurrentFeature(context.getCurrentFeature());
        this.getSpecificationContext(context).setCurrentIteration(context.getCurrentIteration());
        this.runInitializer(context, context.getSpec());
    }

    private void runInitializer(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunInitializer(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunInitializer(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunInitializer(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.INITIALIZER);
        result.setFeature(currentFeature);
        if (spec.getIsBottomSpec()) {
            currentFeature.getInitializerInterceptors().forEach(result::addInterceptor);
        }
        spec.getInitializerInterceptors().forEach(result::addInterceptor);
        return result;
    }

    public void doRunInitializer(SpockExecutionContext context, SpecInfo spec) {
        this.runInitializer(context, spec.getSuperSpec());
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        this.invoke(context, context.getCurrentInstance(), spec.getInitializerMethod(), new Object[0]);
    }

    void runSetup(SpockExecutionContext context) {
        this.runSetup(context, context.getSpec());
    }

    private void runSetup(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunSetup(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunSetup(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunSetup(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.SETUP);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        if (spec.getIsBottomSpec()) {
            currentFeature.getSetupInterceptors().forEach(result::addInterceptor);
        }
        spec.getSetupInterceptors().forEach(result::addInterceptor);
        return result;
    }

    private void doRunSetup(SpockExecutionContext context, SpecInfo spec) {
        this.runSetup(context, spec.getSuperSpec());
        for (MethodInfo method : spec.getSetupMethods()) {
            if (context.getErrorInfoCollector().hasErrors()) {
                return;
            }
            method.setFeature(context.getCurrentFeature());
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
    }

    void runFeatureMethod(SpockExecutionContext context) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        MethodInfo featureIteration = new MethodInfo(context.getCurrentFeature().getFeatureMethod());
        featureIteration.setIteration(context.getCurrentIteration());
        Object[] dataValues = context.getCurrentIteration().getDataValues();
        this.invoke(context, context.getCurrentInstance(), featureIteration, dataValues);
    }

    void runCleanup(SpockExecutionContext context) {
        this.runCleanup(context, context.getSpec());
    }

    private void runCleanup(SpockExecutionContext context, SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.invoke(context, this, this.createMethodInfoForDoRunCleanup(context, spec), spec);
    }

    private MethodInfo createMethodInfoForDoRunCleanup(SpockExecutionContext context, SpecInfo spec) {
        FeatureInfo currentFeature = context.getCurrentFeature();
        MethodInfo result = new MethodInfo((target, arguments) -> {
            this.doRunCleanup(context, spec);
            return null;
        });
        result.setParent(currentFeature.getParent());
        result.setKind(MethodKind.CLEANUP);
        result.setFeature(currentFeature);
        result.setIteration(context.getCurrentIteration());
        if (spec.getIsBottomSpec()) {
            currentFeature.getCleanupInterceptors().forEach(result::addInterceptor);
        }
        spec.getCleanupInterceptors().forEach(result::addInterceptor);
        return result;
    }

    private void doRunCleanup(SpockExecutionContext context, SpecInfo spec) {
        if (spec.getIsBottomSpec()) {
            this.runIterationCleanups(context);
        }
        for (MethodInfo method : spec.getCleanupMethods()) {
            this.invoke(context, context.getCurrentInstance(), method, new Object[0]);
        }
        this.runCleanup(context, spec.getSuperSpec());
    }

    private void runIterationCleanups(SpockExecutionContext context) {
        for (Runnable cleanup : context.getCurrentIteration().getCleanups()) {
            try {
                cleanup.run();
            }
            catch (Throwable t) {
                ErrorInfo error = new ErrorInfo(CollectionUtil.getFirstElement(context.getSpec().getCleanupMethods()), t);
                this.supervisor.error(context.getErrorInfoCollector(), error);
            }
        }
    }

    void runCloseContextStoreProvider(SpockExecutionContext context, MethodKind kind) {
        MethodInfo methodInfo = this.createMethodInfoForCloseContextStoreProvider(context, kind);
        this.invokeRaw(context, context.getStoreProvider(), methodInfo, new Object[0]);
    }

    private MethodInfo createMethodInfoForCloseContextStoreProvider(SpockExecutionContext context, MethodKind kind) {
        MethodInfo result = new MethodInfo((target, arguments) -> {
            context.getStoreProvider().close();
            return null;
        });
        result.setKind(kind);
        return result;
    }

    protected void invoke(SpockExecutionContext context, Object target, MethodInfo method, Object ... arguments) {
        Object[] methodArguments;
        int parameterCount;
        if (method == null || method.isExcluded()) {
            return;
        }
        int n = parameterCount = method.getReflection() == null ? arguments.length : ((Method)method.getReflection()).getParameterCount();
        if (arguments.length == parameterCount) {
            methodArguments = arguments;
        } else {
            methodArguments = new Object[parameterCount];
            System.arraycopy(arguments, 0, methodArguments, 0, arguments.length);
            Arrays.fill(methodArguments, arguments.length, parameterCount, MethodInfo.MISSING_ARGUMENT);
        }
        List<Object> scopedInterceptors = Collections.emptyList();
        if (context.getCurrentFeature() != null) {
            scopedInterceptors = context.getCurrentFeature().getScopedMethodInterceptors(method);
        }
        if (method.getInterceptors().isEmpty() && scopedInterceptors.isEmpty()) {
            this.invokeRaw(context, target, method, methodArguments);
            return;
        }
        MethodInvocation invocation = new MethodInvocation(context.getCurrentFeature(), context.getCurrentIteration(), context.getStoreProvider(), context.getSharedInstance(), context.getCurrentInstance(), target, method, scopedInterceptors, methodArguments);
        try {
            invocation.proceed();
        }
        catch (Throwable throwable) {
            ErrorInfo error = new ErrorInfo(method, throwable);
            this.supervisor.error(context.getErrorInfoCollector(), error);
        }
    }

    protected Object invokeRaw(SpockExecutionContext context, Object target, MethodInfo method, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (Throwable throwable) {
            this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(method, throwable));
            return null;
        }
    }

    protected SpecificationContext getSpecificationContext(SpockExecutionContext context) {
        return (SpecificationContext)context.getCurrentInstance().getSpecificationContext();
    }
}

