/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.spockframework.runtime.SpecUtil;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.DataProcessorMetadata;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.DataProviderMetadata;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.SpecMetadata;
import org.spockframework.util.InternalIdentifiers;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

public class SpecInfoBuilder {
    private final Class<?> clazz;
    private final SpecInfo spec = new SpecInfo();

    public SpecInfoBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public SpecInfo build() {
        this.doBuild();
        int order = 0;
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            for (FeatureInfo feature : curr.getFeatures()) {
                feature.setDeclarationOrder(order);
                feature.setExecutionOrder(order);
                ++order;
            }
        }
        return this.spec;
    }

    private SpecInfo doBuild() {
        this.buildSuperSpec();
        this.buildSpec();
        this.buildFields();
        this.buildFeatures();
        this.buildInitializerMethods();
        this.buildFixtureMethods();
        return this.spec;
    }

    private void buildSuperSpec() {
        Class<?> superClass = this.clazz.getSuperclass();
        if (superClass == Object.class || superClass == Specification.class) {
            return;
        }
        SpecInfo superSpec = new SpecInfoBuilder(superClass).doBuild();
        this.spec.setSuperSpec(superSpec);
        superSpec.setSubSpec(this.spec);
    }

    private void buildSpec() {
        SpecUtil.checkIsSpec(this.clazz);
        SpecMetadata metadata = this.clazz.getAnnotation(SpecMetadata.class);
        this.spec.setParent(null);
        this.spec.setPackage(ReflectionUtil.getPackageName(this.clazz));
        this.spec.setName(this.clazz.getSimpleName());
        this.spec.setLine(metadata.line());
        this.spec.setReflection(this.clazz);
        this.spec.setFilename(metadata.filename());
    }

    private void buildFields() {
        for (Field field : this.clazz.getDeclaredFields()) {
            FieldMetadata metadata = field.getAnnotation(FieldMetadata.class);
            if (metadata == null) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setParent(this.spec);
            fieldInfo.setReflection(field);
            fieldInfo.setName(metadata.name());
            fieldInfo.setOrdinal(metadata.ordinal());
            fieldInfo.setLine(metadata.line());
            fieldInfo.setHasInitializer(metadata.initializer());
            this.spec.addField(fieldInfo);
        }
        this.spec.getFields().sort(Comparator.comparingInt(FieldInfo::getOrdinal));
    }

    private void buildFeatures() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            FeatureMetadata metadata = method.getAnnotation(FeatureMetadata.class);
            if (metadata == null) continue;
            method.setAccessible(true);
            this.spec.addFeature(this.createFeature(method, metadata));
        }
        this.spec.getFeatures().sort(Comparator.comparingInt(FeatureInfo::getDeclarationOrder));
    }

    private FeatureInfo createFeature(Method method, FeatureMetadata featureMetadata) {
        FeatureInfo feature = new FeatureInfo();
        feature.setParent(this.spec);
        feature.setName(featureMetadata.name());
        feature.setLine(featureMetadata.line());
        feature.setDeclarationOrder(featureMetadata.ordinal());
        for (String name : featureMetadata.parameterNames()) {
            feature.addParameterName(name);
        }
        MethodInfo featureMethod = new MethodInfo();
        featureMethod.setParent(this.spec);
        featureMethod.setName(featureMetadata.name());
        featureMethod.setLine(featureMetadata.line());
        featureMethod.setFeature(feature);
        featureMethod.setReflection(method);
        featureMethod.setKind(MethodKind.FEATURE);
        feature.setFeatureMethod(featureMethod);
        String processorMethodName = InternalIdentifiers.getDataProcessorName(method.getName());
        MethodInfo dataProcessorMethod = this.createMethod(processorMethodName, MethodKind.DATA_PROCESSOR);
        if (dataProcessorMethod != null) {
            feature.setDataProcessorMethod(dataProcessorMethod);
            DataProcessorMetadata dataProcessorMetadata = dataProcessorMethod.getAnnotation(DataProcessorMetadata.class);
            for (String dataVariable : dataProcessorMetadata.dataVariables()) {
                feature.addDataVariable(dataVariable);
            }
            int providerCount = 0;
            String providerMethodName = InternalIdentifiers.getDataProviderName(method.getName(), providerCount++);
            MethodInfo providerMethod = this.createMethod(providerMethodName, MethodKind.DATA_PROVIDER);
            while (providerMethod != null) {
                feature.addDataProvider(this.createDataProvider(feature, providerMethod));
                providerMethodName = InternalIdentifiers.getDataProviderName(method.getName(), providerCount++);
                providerMethod = this.createMethod(providerMethodName, MethodKind.DATA_PROVIDER);
            }
        }
        for (BlockMetadata blockMetadata : featureMetadata.blocks()) {
            BlockInfo block = new BlockInfo();
            block.setKind(blockMetadata.kind());
            block.setTexts(Arrays.asList(blockMetadata.texts()));
            feature.addBlock(block);
        }
        return feature;
    }

    private DataProviderInfo createDataProvider(FeatureInfo feature, MethodInfo method) {
        DataProviderMetadata metadata = method.getAnnotation(DataProviderMetadata.class);
        DataProviderInfo provider = new DataProviderInfo();
        provider.setParent(feature);
        provider.setLine(metadata.line());
        provider.setDataVariables(Arrays.asList(metadata.dataVariables()));
        provider.setPreviousDataTableVariables(Arrays.asList(metadata.previousDataTableVariables()));
        provider.setDataProviderMethod(method);
        return provider;
    }

    private MethodInfo createMethod(String name, MethodKind kind) {
        Method reflection = this.findMethod(name, kind);
        if (reflection == null) {
            return null;
        }
        return this.createMethod(reflection, kind, name);
    }

    private MethodInfo createMethod(Method method, MethodKind kind, String name) {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.spec);
        methodInfo.setName(name);
        methodInfo.setReflection(method);
        methodInfo.setKind(kind);
        return methodInfo;
    }

    private Method findMethod(String name, MethodKind kind) {
        List methods = Arrays.stream(((Class)this.spec.getReflection()).getDeclaredMethods()).filter(m -> m.getName().equals(name)).collect(Collectors.toList());
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() > 1) {
            methods.sort(Comparator.comparingInt(Method::getParameterCount));
            throw new SpockException(String.format("Multiple %s methods found in '%s'. Methods %s. There can only be one per specification class.", new Object[]{kind, ((Class)this.spec.getReflection()).getName(), methods}));
        }
        Method method = (Method)methods.get(0);
        method.setAccessible(true);
        return method;
    }

    private void buildInitializerMethods() {
        MethodInfo sharedInitializerMethod;
        MethodInfo initializerMethod = this.createMethod("$spock_initializeFields", MethodKind.INITIALIZER);
        if (initializerMethod != null) {
            this.spec.setInitializerMethod(initializerMethod);
        }
        if ((sharedInitializerMethod = this.createMethod("$spock_initializeSharedFields", MethodKind.SHARED_INITIALIZER)) != null) {
            this.spec.setSharedInitializerMethod(sharedInitializerMethod);
        }
    }

    private void buildFixtureMethods() {
        MethodInfo setupSpecMethod;
        MethodInfo setupMethod;
        MethodInfo cleanupSpecMethod;
        MethodInfo cleanupMethod = this.createMethod("cleanup", MethodKind.CLEANUP);
        if (cleanupMethod != null) {
            this.spec.addCleanupMethod(cleanupMethod);
        }
        if ((cleanupSpecMethod = this.createMethod("cleanupSpec", MethodKind.CLEANUP_SPEC)) != null) {
            this.spec.addCleanupSpecMethod(cleanupSpecMethod);
        }
        if ((setupMethod = this.createMethod("setup", MethodKind.SETUP)) != null) {
            this.spec.addSetupMethod(setupMethod);
        }
        if ((setupSpecMethod = this.createMethod("setupSpec", MethodKind.SETUP_SPEC)) != null) {
            this.spec.addSetupSpecMethod(setupSpecMethod);
        }
    }
}

