/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Objects;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.spockframework.runtime.NamespacedExtensionStore;
import org.spockframework.runtime.extension.IStore;

public class StoreProvider
implements AutoCloseable {
    private static final NamespacedHierarchicalStore.CloseAction<IStore.Namespace> CLOSE_ACTION = (namespace, key, value) -> {
        if (value instanceof AutoCloseable) {
            ((AutoCloseable)value).close();
        }
    };
    private final NamespacedHierarchicalStore<IStore.Namespace> backend;
    private final StoreProvider parent;

    private StoreProvider(NamespacedHierarchicalStore<IStore.Namespace> backend, StoreProvider parent) {
        this.backend = Objects.requireNonNull(backend);
        this.parent = parent;
    }

    public static StoreProvider createRootStoreProvider() {
        return new StoreProvider(StoreProvider.newBackendStore(null), null);
    }

    public StoreProvider createChildStoreProvider() {
        return new StoreProvider(StoreProvider.newBackendStore(this.backend), this);
    }

    public NamespacedExtensionStore getStore(IStore.Namespace namespace) {
        return new NamespacedExtensionStore(this.backend, () -> this.parent == null ? null : this.parent.getStore(namespace), namespace);
    }

    private static NamespacedHierarchicalStore<IStore.Namespace> newBackendStore(NamespacedHierarchicalStore<IStore.Namespace> backend) {
        return new NamespacedHierarchicalStore(backend, CLOSE_ACTION);
    }

    @Override
    public void close() throws Exception {
        this.backend.close();
    }
}

