/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.util.function.Function;
import java.util.function.Supplier;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ParameterInfo;

public class ParameterResolver {
    public static void resolveParameter(IMethodInvocation invocation, ParameterInfo parameterInfo, Supplier<?> valueSupplier) {
        invocation.resolveArgument(parameterInfo.getIndex(), valueSupplier.get());
    }

    public static class Interceptor<T>
    implements IMethodInterceptor {
        private final ParameterInfo parameterInfo;
        private final Function<IMethodInvocation, T> valueSupplier;

        public Interceptor(ParameterInfo parameterInfo, Function<IMethodInvocation, T> valueSupplier) {
            this.parameterInfo = parameterInfo;
            this.valueSupplier = valueSupplier;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            ParameterResolver.resolveParameter(invocation, this.parameterInfo, () -> this.valueSupplier.apply(invocation));
            invocation.proceed();
        }
    }
}

