/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.spockframework.runtime.IDataIterator;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IDataDriver;
import org.spockframework.runtime.extension.IIterationRunner;
import org.spockframework.runtime.model.ExecutionResult;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ParameterInfo;
import spock.lang.RepeatUntilFailure;

public class RepeatUntilFailureExtension
implements IAnnotationDrivenExtension<RepeatUntilFailure> {
    @Override
    public void visitFeatureAnnotation(RepeatUntilFailure annotation, FeatureInfo feature) {
        if (annotation.ignoreRest()) {
            feature.getSpec().getBottomSpec().getAllFeatures().stream().filter(f -> f != feature && f.getFeatureMethod().getAnnotation(RepeatUntilFailure.class) == null).forEach(f -> f.skip("Focussed test run with @RepeatUntilFailure."));
        }
        feature.setForceParameterized(true);
        feature.setDataDriver(new RepeatUntilFailureDataDriver(annotation.maxAttempts()));
    }

    private static class RepeatUntilFailureDataDriver
    implements IDataDriver {
        private final int maxAttempts;

        public RepeatUntilFailureDataDriver(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public void runIterations(IDataIterator dataIterator, IIterationRunner iterationRunner, List<ParameterInfo> parameters) {
            int estimatedNumIterations = dataIterator.getEstimatedNumIterations();
            int maxIterations = estimatedNumIterations * this.maxAttempts;
            ArrayList arguments = new ArrayList(estimatedNumIterations);
            dataIterator.forEachRemaining(arguments::add);
            for (int attempt = 0; attempt < this.maxAttempts; ++attempt) {
                for (Object[] args : arguments) {
                    try {
                        ExecutionResult executionResult = iterationRunner.runIteration(args, maxIterations).get();
                        if (executionResult != ExecutionResult.FAILED) continue;
                        return;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return;
                    }
                }
            }
        }
    }
}

