/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.ParameterResolver;
import org.spockframework.runtime.extension.builtin.SnapshotConfig;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Assert;
import org.spockframework.util.Checks;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Snapshot;
import spock.lang.Snapshotter;

public class SnapshotExtension
implements IAnnotationDrivenExtension<Snapshot> {
    private final SnapshotConfig config;

    public SnapshotExtension(SnapshotConfig config) {
        this.config = Assert.notNull(config);
        Checks.notNull(config.rootPath, () -> "Root path must be set, when using @Snapshot");
    }

    @Override
    public void visitFieldAnnotation(Snapshot annotation, FieldInfo field) {
        Checks.checkArgument(Snapshotter.class.isAssignableFrom(field.getType()), () -> "Field must be of type spock.lang.Snapshotter or a valid subtype");
        SpecInfo spec = ((SpecInfo)field.getParent()).getBottomSpec();
        spec.getAllFeatures().forEach(featureInfo -> featureInfo.addTestTag("snapshot"));
        spec.addSetupInterceptor(new SnapshotInterceptor(annotation, field));
    }

    @Override
    public void visitParameterAnnotation(Snapshot annotation, ParameterInfo parameter) {
        Class<?> type = ((Parameter)parameter.getReflection()).getType();
        Checks.checkArgument(Snapshotter.class.isAssignableFrom(type), () -> "Field must be of type spock.lang.Snapshotter or a valid subtype");
        MethodInfo method = (MethodInfo)parameter.getParent();
        method.getFeature().addTestTag("snapshot");
        method.addInterceptor(new ParameterResolver.Interceptor<Snapshotter>(parameter, invocation -> this.createSnapshotter((IMethodInvocation)invocation, type, annotation)));
    }

    private Snapshotter createSnapshotter(IMethodInvocation invocation, Class<?> type, Snapshot annotation) {
        String extension = annotation.extension().equals("<default>") ? Checks.notNull(this.config.defaultExtension, () -> "'snapshot.defaultExtension' must not be null.") : annotation.extension();
        Snapshotter.Store snapshotStore = new Snapshotter.Store(invocation.getMethod().getIteration(), this.config.rootPath, this.config.updateSnapshots, this.config.writeActualSnapshotOnMismatch, extension, Charset.forName(annotation.charset()));
        Checks.checkArgument(Snapshotter.class.isAssignableFrom(type), () -> "Target must be of type spock.lang.Snapshotter or a valid subtype");
        return (Snapshotter)ReflectionUtil.newInstance(type, snapshotStore);
    }

    private class SnapshotInterceptor
    implements IMethodInterceptor {
        private final FieldInfo field;
        private final Snapshot annotation;

        private SnapshotInterceptor(Snapshot annotation, FieldInfo field) {
            this.field = Assert.notNull(field);
            this.annotation = Assert.notNull(annotation);
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            this.field.writeValue(invocation.getInstance(), SnapshotExtension.this.createSnapshotter(invocation, this.field.getType(), this.annotation));
            invocation.proceed();
        }
    }
}

