/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.List;
import org.spockframework.runtime.AbstractRunListener;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.parallel.ExecutionMode;
import spock.lang.Stepwise;

public class StepwiseExtension
implements IAnnotationDrivenExtension<Stepwise> {
    @Override
    public void visitSpecAnnotation(Stepwise annotation, SpecInfo spec) {
        this.sortFeaturesInDeclarationOrder(spec);
        this.includeFeaturesBeforeLastIncludedFeature(spec);
        this.skipFeaturesAfterFirstFailingFeature(spec);
        spec.setChildExecutionMode(ExecutionMode.SAME_THREAD);
    }

    @Override
    public void visitFeatureAnnotation(Stepwise annotation, FeatureInfo feature) {
        if (!feature.isParameterized()) {
            throw new InvalidSpecException(String.format("Cannot use @Stepwise, feature method %s.%s is not data-driven", ((Class)feature.getSpec().getReflection()).getCanonicalName(), feature.getDisplayName()));
        }
        feature.setExecutionMode(ExecutionMode.SAME_THREAD);
        feature.getFeatureMethod().addInterceptor(invocation -> {
            try {
                invocation.proceed();
            }
            catch (Throwable t) {
                invocation.getFeature().skip("skipping subsequent iterations after failure");
                throw t;
            }
        });
    }

    private void sortFeaturesInDeclarationOrder(SpecInfo spec) {
        for (FeatureInfo feature : spec.getFeatures()) {
            feature.setExecutionOrder(feature.getDeclarationOrder());
        }
    }

    private void includeFeaturesBeforeLastIncludedFeature(SpecInfo spec) {
        List<FeatureInfo> features = spec.getFeatures();
        boolean includeRemaining = false;
        for (int i = features.size() - 1; i >= 0; --i) {
            FeatureInfo feature = features.get(i);
            if (includeRemaining) {
                feature.setExcluded(false);
            } else if (!feature.isExcluded()) {
                includeRemaining = true;
            }
            if (i <= 0) continue;
            feature.addImpliedFeature(features.get(i - 1));
        }
    }

    private void skipFeaturesAfterFirstFailingFeature(final SpecInfo spec) {
        spec.getBottomSpec().addListener(new AbstractRunListener(){

            @Override
            public void error(ErrorInfo error) {
                if (!((SpecInfo)error.getMethod().getParent()).equals(spec)) {
                    return;
                }
                List<FeatureInfo> features = spec.getFeatures();
                int indexOfFailedFeature = features.indexOf(error.getMethod().getFeature());
                for (int i = indexOfFailedFeature + 1; i < features.size(); ++i) {
                    features.get(i).skip("Skipped due to previous Error (by @Stepwise)");
                }
            }
        });
    }
}

