/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.EnumSet;
import java.util.Set;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.builtin.TempDirInterceptor;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.ParameterInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.tempdir.TempDirConfiguration;
import org.spockframework.util.Checks;
import org.spockframework.util.UnreachableCodeError;
import spock.lang.TempDir;

public class TempDirExtension
implements IAnnotationDrivenExtension<TempDir> {
    private static final Set<MethodKind> VALID_METHOD_KINDS = EnumSet.of(MethodKind.SETUP, MethodKind.SETUP_SPEC, MethodKind.FEATURE);
    private final TempDirConfiguration configuration;

    public TempDirExtension(TempDirConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visitFieldAnnotation(TempDir annotation, FieldInfo field) {
        TempDir.CleanupMode cleanupMode = this.getCleanupMode(annotation);
        TempDirInterceptor interceptor = TempDirInterceptor.forField(field, this.configuration.baseDir, annotation, cleanupMode);
        SpecInfo specInfo = (SpecInfo)field.getParent();
        if (field.isShared()) {
            specInfo.getBottomSpec().addSharedInitializerInterceptor(interceptor);
        } else {
            specInfo.addInitializerInterceptor(interceptor);
        }
        if (cleanupMode == TempDir.CleanupMode.ON_SUCCESS) {
            TempDirExtension.registerForAllFeatures(specInfo, new TempDirInterceptor.FailureTracker(annotation));
        }
    }

    private static void registerForAllFeatures(SpecInfo specInfo, IMethodInterceptor interceptor) {
        specInfo.getBottomSpec().getAllFeatures().forEach(featureInfo -> featureInfo.getFeatureMethod().addInterceptor(interceptor));
    }

    @Override
    public void visitParameterAnnotation(TempDir annotation, ParameterInfo parameter) {
        TempDir.CleanupMode cleanupMode = this.getCleanupMode(annotation);
        MethodInfo methodInfo = (MethodInfo)parameter.getParent();
        Checks.checkArgument(VALID_METHOD_KINDS.contains((Object)methodInfo.getKind()), () -> "@TempDir can only be used on setup, setupSpec or feature method parameters.");
        TempDirInterceptor interceptor = TempDirInterceptor.forParameter(parameter, this.configuration.baseDir, annotation, cleanupMode);
        methodInfo.addInterceptor(interceptor);
        if (cleanupMode == TempDir.CleanupMode.ON_SUCCESS) {
            TempDirInterceptor.FailureTracker failureTracker = new TempDirInterceptor.FailureTracker(annotation);
            switch (methodInfo.getKind()) {
                case SETUP: 
                case SETUP_SPEC: {
                    TempDirExtension.registerForAllFeatures((SpecInfo)methodInfo.getParent(), failureTracker);
                    break;
                }
                case FEATURE: {
                    methodInfo.addInterceptor(failureTracker);
                    break;
                }
                default: {
                    throw new UnreachableCodeError();
                }
            }
        }
    }

    private TempDir.CleanupMode getCleanupMode(TempDir annotation) {
        TempDir.CleanupMode cleanupMode = annotation.cleanup();
        cleanupMode = cleanupMode == TempDir.CleanupMode.DEFAULT ? this.configuration.cleanup : cleanupMode;
        return cleanupMode;
    }
}

