/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.extension.builtin.ThreadDumpUtility;
import org.spockframework.util.CollectionUtil;
import spock.util.environment.OperatingSystem;

public enum ThreadDumpUtilityType implements ThreadDumpUtility
{
    JSTACK{

        @Override
        String getFileName() {
            return OperatingSystem.getCurrent().isWindows() ? "jstack.exe" : "jstack";
        }

        @Override
        public List<String> getCommand(Path javaHome, long pid) {
            return CollectionUtil.listOf(this.getUtilityPath(javaHome).toString(), Long.toString(pid));
        }
    }
    ,
    JCMD{

        @Override
        String getFileName() {
            return OperatingSystem.getCurrent().isWindows() ? "jcmd.exe" : "jcmd";
        }

        @Override
        public List<String> getCommand(Path javaHome, long pid) {
            return CollectionUtil.listOf(this.getUtilityPath(javaHome).toString(), Long.toString(pid), "Thread.print");
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    abstract String getFileName();

    protected Path getUtilityPath(Path javaHome) {
        Path utilityPath = "jre".equals(javaHome.getFileName().toString()) ? javaHome.resolve("../bin").resolve(this.getFileName()).normalize() : javaHome.resolve("bin").resolve(this.getFileName()).normalize();
        if (!Files.exists(utilityPath, new LinkOption[0])) {
            throw new SpockException("Could not find requested thread dump capturing utility '" + this.name().toLowerCase() + "' under expected path '" + utilityPath + "'");
        }
        return utilityPath;
    }
}

