/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.spockframework.runtime.SpockTimeoutError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.TimeoutConfiguration;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.JavaProcessThreadDumpCollector;
import org.spockframework.util.Pair;
import org.spockframework.util.TextUtil;
import org.spockframework.util.TimeUtil;
import spock.lang.Timeout;

public class TimeoutInterceptor
implements IMethodInterceptor {
    private final Timeout timeout;
    private final TimeoutConfiguration configuration;
    private final JavaProcessThreadDumpCollector threadDumpCollector;

    public TimeoutInterceptor(Timeout timeout, TimeoutConfiguration configuration) {
        this.timeout = timeout;
        this.configuration = configuration;
        this.threadDumpCollector = JavaProcessThreadDumpCollector.create(configuration.threadDumpUtilityType);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        final Thread mainThread = Thread.currentThread();
        final SynchronousQueue sync = new SynchronousQueue();
        final CountDownLatch startLatch = new CountDownLatch(2);
        final String methodName = invocation.getMethod().getName();
        final double timeoutSeconds = TimeUtil.toSeconds(this.timeout.value(), this.timeout.unit());
        new Thread(String.format("[spock.lang.Timeout] Watcher for method '%s'", methodName)){

            @Override
            public void run() {
                StackTraceElement[] stackTrace = new StackTraceElement[]{};
                long waitMillis = TimeoutInterceptor.this.timeout.unit().toMillis(TimeoutInterceptor.this.timeout.value());
                boolean synced = false;
                long timeoutAt = 0L;
                int unsuccessfulInterruptAttempts = 0;
                TimeoutInterceptor.syncWithThread(startLatch, "feature", methodName);
                while (!synced) {
                    try {
                        synced = sync.offer(stackTrace, waitMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (synced) continue;
                    long now = System.nanoTime();
                    if (stackTrace.length == 0) {
                        TimeoutInterceptor.this.logMethodTimeout(methodName, timeoutSeconds);
                        stackTrace = mainThread.getStackTrace();
                        waitMillis = 250L;
                        timeoutAt = now;
                    } else {
                        TimeoutInterceptor.this.logUnsuccessfulInterrupt(methodName, now, timeoutAt, waitMillis *= 2L, ++unsuccessfulInterruptAttempts);
                    }
                    mainThread.interrupt();
                }
            }
        }.start();
        TimeoutInterceptor.syncWithThread(startLatch, "watcher", methodName);
        Throwable saved = null;
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            saved = t;
        }
        StackTraceElement[] stackTrace = null;
        while (stackTrace == null) {
            try {
                stackTrace = (StackTraceElement[])sync.take();
            }
            catch (InterruptedException e) {
                saved = e;
            }
        }
        if (stackTrace.length > 0) {
            String msg = String.format("Method timed out after %1.2f seconds", timeoutSeconds);
            SpockTimeoutError error = new SpockTimeoutError(timeoutSeconds, msg);
            error.setStackTrace(stackTrace);
            throw error;
        }
        if (saved != null) {
            throw saved;
        }
    }

    private void logUnsuccessfulInterrupt(String methodName, long now, long timeoutAt, long waitMillis, int unsuccessfulAttempts) {
        System.err.printf("[spock.lang.Timeout] Method '%s' has not stopped after timing out %1.2f seconds ago - interrupting. Next try in %1.2f seconds.\n%n", methodName, (double)Duration.ofNanos(now - timeoutAt).toMillis() / 1000.0, (double)waitMillis / 1000.0);
        if (unsuccessfulAttempts <= this.configuration.maxInterruptAttemptsWithThreadDumps) {
            this.logThreadDumpOfCurrentJvm();
            this.configuration.interruptAttemptListeners.forEach(Runnable::run);
            if (unsuccessfulAttempts == this.configuration.maxInterruptAttemptsWithThreadDumps) {
                System.out.println("[spock.lang.Timeout] No further thread dumps will be logged and no timeout listeners will be run, as the number of unsuccessful interrupt attempts exceeds configured maximum of logged attempts");
            }
        }
    }

    private void logMethodTimeout(String methodName, double timeoutSeconds) {
        System.err.printf("[spock.lang.Timeout] Method '%s' timed out after %1.2f seconds.%n", methodName, timeoutSeconds);
        this.configuration.interruptAttemptListeners.forEach(Runnable::run);
    }

    private void logThreadDumpOfCurrentJvm() {
        if (this.configuration.printThreadDumpsOnInterruptAttempts) {
            StringBuilder sb = new StringBuilder();
            try {
                this.threadDumpCollector.appendThreadDumpOfCurrentJvm(sb);
                System.err.println(TimeoutInterceptor.removeThisThread(sb.toString()));
            }
            catch (Throwable e) {
                ExceptionUtil.rethrowIfUnrecoverable(e);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stream));
                String result = "Error in attempt to fetch thread dumps: " + stream;
                if (sb.length() > 0) {
                    result = result + "\n\nPartial thread dumps:\n" + sb;
                }
                System.err.println(result);
            }
        }
    }

    private static String removeThisThread(String threadDumpOutput) {
        Thread thisThread = Thread.currentThread();
        String threadName = thisThread.getName();
        long threadId = thisThread.getId();
        List<String> lines = Arrays.asList(threadDumpOutput.split("\n"));
        Pair<Integer, Integer> thisThreadSection = TimeoutInterceptor.findThreadSection(lines, threadName, threadId);
        if (thisThreadSection == null) {
            return threadDumpOutput;
        }
        String start = TextUtil.join("\n", lines.subList(0, thisThreadSection.first()));
        int thisThreadSectionStop = thisThreadSection.second();
        if (thisThreadSectionStop == lines.size()) {
            return start;
        }
        return start + TextUtil.join("\n", lines.subList(thisThreadSectionStop + 1, lines.size() - 1));
    }

    private static Pair<Integer, Integer> findThreadSection(List<String> lines, String threadName, long threadId) {
        String lineFormat = "\"%s\" #%d";
        int threadSectionStart = -1;
        for (int i = 0; i < lines.size(); ++i) {
            if (lines.get(i).startsWith(String.format(lineFormat, threadName, threadId))) {
                threadSectionStart = i;
                continue;
            }
            if (threadSectionStart <= 0 || !lines.get(i).isEmpty()) continue;
            return Pair.of(threadSectionStart, i);
        }
        return null;
    }

    private static void syncWithThread(CountDownLatch startLatch, String threadName, String methodName) {
        try {
            startLatch.countDown();
            startLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            System.out.printf("[spock.lang.Timeout] Could not sync with %s thread for method '%s'", threadName, methodName);
        }
    }
}

