/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.UseInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.parallel.ExecutionMode;
import spock.util.mop.Use;

public class UseExtension
implements IAnnotationDrivenExtension<Use> {
    @Override
    public void visitSpecAnnotations(List<Use> annotations, SpecInfo spec) {
        this.addInterceptor(annotations, spec.getBottomSpec());
        spec.setChildExecutionMode(ExecutionMode.SAME_THREAD);
    }

    @Override
    public void visitFeatureAnnotations(List<Use> annotations, FeatureInfo feature) {
        this.addInterceptor(annotations, feature.getFeatureMethod());
    }

    @Override
    public void visitFixtureAnnotations(List<Use> annotations, MethodInfo fixtureMethod) {
        this.addInterceptor(annotations, fixtureMethod);
    }

    private void addInterceptor(List<Use> annotations, IInterceptable interceptable) {
        interceptable.addInterceptor(new UseInterceptor(annotations.stream().map(Use::value).flatMap(Arrays::stream).collect(Collectors.toSet())));
    }
}

