/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TestTag {
    private static final IntPredicate INVALID_CODE_POINTS = Stream.of(Character::isWhitespace, Character::isISOControl, TestTag.isReservedChar()).reduce(IntPredicate::or).get();
    private static final String RESERVED_CHARACTERS = "!&(),|";
    private final String value;

    private TestTag(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static TestTag create(String tag) {
        if (!TestTag.isValid(tag)) {
            throw new IllegalArgumentException("Invalid tag: [" + tag + "] contains invalid character(s): " + TestTag.getInvalidCharacters(tag));
        }
        return new TestTag(tag);
    }

    public static boolean isValid(String value) {
        return value != null && value.length() > 0 && value.codePoints().noneMatch(INVALID_CODE_POINTS);
    }

    private static String getInvalidCharacters(String value) {
        if (value == null) {
            return "tag is null";
        }
        if (value.isEmpty()) {
            return "tag is empty";
        }
        return value.codePoints().filter(INVALID_CODE_POINTS).distinct().mapToObj(Character::getName).collect(Collectors.joining(", "));
    }

    private static IntPredicate isReservedChar() {
        return RESERVED_CHARACTERS.codePoints().mapToObj(codePoint -> other -> codePoint == other).reduce(IntPredicate::or).orElseThrow(() -> new IllegalStateException("This should never happen (tm)"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestTag testTag = (TestTag)o;
        return this.value.equals(testTag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

