/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;

public abstract class Checks {
    @Contract(value="false, _ -> fail")
    public static void checkState(boolean expression, Supplier<String> messageProvider) {
        if (!expression) {
            throw new IllegalStateException(messageProvider.get());
        }
    }

    @Contract(value="false, _ -> fail")
    public static void checkArgument(boolean expression, Supplier<String> messageProvider) {
        if (!expression) {
            throw new IllegalArgumentException(messageProvider.get());
        }
    }

    public static <T> T notNull(T object, Supplier<String> messageProvider) {
        Checks.checkArgument(object != null, messageProvider);
        return object;
    }

    public static <T> T[] notEmpty(T[] array, Supplier<String> messageProvider) {
        Checks.checkArgument(array != null && array.length > 0, messageProvider);
        return array;
    }

    public static <T> T[] containsNoNullElements(T[] array, Supplier<String> messageProvider) {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Checks.notNull(object, messageProvider));
        }
        return array;
    }
}

