/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public abstract class GenericTypeReflectorUtil {
    public static Class<?> erase(Type type) {
        return GenericTypeReflector.erase((Type)type);
    }

    public static Type getExactSuperType(Type subType, Class<?> searchSuperClass) {
        return GenericTypeReflector.getExactSuperType((Type)subType, searchSuperClass);
    }

    public static Type[] getParameterTypes(Executable executable, Type declaringType) {
        Type[] parameterTypes = GenericTypeReflector.getParameterTypes((Executable)executable, (Type)declaringType);
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = GenericTypeReflectorUtil.resolveTypeVariableWithBound(parameterTypes[i]);
        }
        return parameterTypes;
    }

    public static String getTypeName(Type type) {
        return GenericTypeReflector.getTypeName((Type)type);
    }

    public static Type getExactFieldType(Field f, Type type) {
        return GenericTypeReflector.getExactFieldType((Field)f, (Type)type);
    }

    public static Type getReturnType(Method method, Type declaringType) {
        Type returnType = GenericTypeReflector.getReturnType((Method)method, (Type)declaringType);
        return GenericTypeReflectorUtil.resolveTypeVariableWithBound(returnType);
    }

    private static Type resolveTypeVariableWithBound(Type type) {
        if (type instanceof TypeVariable) {
            List upperBounds = GenericTypeReflector.getUpperBoundClassAndInterfaces((Type)type);
            if (upperBounds.size() == 1) {
                return (Type)upperBounds.get(0);
            }
            return Object.class;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            for (Type actualTypeArgument : paramType.getActualTypeArguments()) {
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                return GenericTypeReflector.erase((Type)type);
            }
        }
        return type;
    }
}

