/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.spockframework.util.Checks;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.GenericTypeReflectorUtil;

public abstract class ReflectionUtil {
    public static String getPackageName(Class<?> clazz) {
        int lengthDiff = clazz.getName().length() - clazz.getSimpleName().length();
        return lengthDiff == 0 ? clazz.getName() : clazz.getName().substring(0, lengthDiff - 1);
    }

    public static Class<?> loadFirstAvailableClass(String ... classNames) {
        for (String className : classNames) {
            Class<?> clazz = ReflectionUtil.loadClassIfAvailable(className);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class<?> loadClassIfAvailable(String className) {
        try {
            return ReflectionUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isClassAvailable(String className) {
        return ReflectionUtil.loadClassIfAvailable(className) != null;
    }

    public static boolean isMethodAvailable(String className, String methodName) {
        try {
            Class<?> clazz = ReflectionUtil.class.getClassLoader().loadClass(className);
            return ReflectionUtil.getMethodByName(clazz, methodName) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, String className) {
        for (Annotation ann : element.getAnnotations()) {
            if (!ann.annotationType().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isAnnotationPresentRecursive(Class<?> cls, Class<? extends Annotation> annotationClass) {
        return cls.isAnnotationPresent(annotationClass) || !Object.class.equals(cls) && ReflectionUtil.isAnnotationPresentRecursive(cls.getSuperclass(), annotationClass);
    }

    public static <T extends Annotation> T getAnnotationRecursive(Class<?> cls, Class<T> annotationClass) {
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (Object.class.equals(cls)) {
            return null;
        }
        return ReflectionUtil.getAnnotationRecursive(cls.getSuperclass(), annotationClass);
    }

    public static <T extends Annotation> List<T> collectAnnotationRecursive(Class<?> cls, Class<T> annotationClass) {
        return ReflectionUtil.collectAnnotationRecursive(cls, annotationClass, new ArrayList());
    }

    private static <T extends Annotation> List<T> collectAnnotationRecursive(Class<?> cls, Class<T> annotationClass, List<T> result) {
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            result.add(annotation);
        }
        if (Object.class.equals(cls)) {
            return result;
        }
        return ReflectionUtil.collectAnnotationRecursive(cls.getSuperclass(), annotationClass, result);
    }

    public static boolean isFinalMethod(Method method) {
        return Modifier.isFinal(method.getDeclaringClass().getModifiers() | method.getModifiers());
    }

    public static boolean isObjectMethod(Method m) {
        return Arrays.asList(Object.class.getMethods()).contains(m);
    }

    public static Method getMethodByName(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodByName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodBySignature(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethodBySignature(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static File getClassFile(Class<?> clazz) {
        CodeSource source = clazz.getProtectionDomain().getCodeSource();
        if (source == null) {
            return null;
        }
        File dir = new File(source.getLocation().getPath());
        if (!dir.isDirectory()) {
            return null;
        }
        File clazzFile = new File(dir, clazz.getName().replace('.', File.separatorChar) + ".class");
        return clazzFile.isFile() ? clazzFile : null;
    }

    public static Object getDefaultValue(Class<?> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        assert (type == Void.TYPE);
        return null;
    }

    public static boolean hasAnyOfTypes(Object value, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public static Class[] getTypes(Object ... objects) {
        return MetaClassHelper.convertToTypeArray((Object[])objects);
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) {
        try {
            ReflectionUtil.validateArguments(method, args);
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            return ExceptionUtil.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            return ExceptionUtil.sneakyThrow(e.getCause());
        }
    }

    public static void validateArguments(Method method, Object[] args) {
        if (!ReflectionUtil.hasValidArguments(args, method.getParameterTypes())) {
            throw new IllegalArgumentException(String.format("Method '%s(%s)' can't be called with parameters '%s'!", method.getName(), Arrays.toString(method.getParameterTypes()), Arrays.toString(args)));
        }
    }

    public static boolean hasValidArguments(Object[] args, Class<?>[] parameterTypes) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (ReflectionUtil.isAssignable(parameterTypes[i], args[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> type, Object arg) {
        if (arg == null) {
            return !type.isPrimitive();
        }
        type = ReflectionUtil.getWrapperType(type);
        Class<?> argType = ReflectionUtil.getWrapperType(arg.getClass());
        return type.isAssignableFrom(argType);
    }

    private static Class<?> getWrapperType(Class<?> type) {
        return type.isPrimitive() ? ReflectionUtil.getDefaultValue(type).getClass() : type;
    }

    public static List<Class<?>> eraseTypes(List<Type> types) {
        ArrayList result = new ArrayList();
        for (Type type : types) {
            result.add(GenericTypeReflectorUtil.erase(type));
        }
        return result;
    }

    public static boolean isToStringOverridden(Class<?> valueClass) {
        try {
            return !Object.class.equals(valueClass.getMethod("toString", new Class[0]).getDeclaringClass());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static void deepCopyFields(Object source, Object target) {
        if (!source.getClass().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("source and target are not compatible.");
        }
        Class<?> clazz = source.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fields = clazz.getDeclaredFields();
            Arrays.stream(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).forEach(field -> ReflectionUtil.copyField(field, source, target));
            clazz = clazz.getSuperclass();
        }
    }

    private static void copyField(Field field, Object source, Object target) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(target, field.get(source));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field.setAccessible(accessible);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Checks.notNull(clazz, () -> "Class must not be null");
        Checks.notNull(args, () -> "Argument array must not be null");
        Checks.containsNoNullElements(args, () -> "Individual arguments must not be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            return ReflectionUtil.newInstance(clazz.getDeclaredConstructor(parameterTypes), args);
        }
        catch (Throwable t) {
            return (T)ExceptionUtil.sneakyThrow(ExceptionUtil.getUnderlyingCause(t));
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        Checks.notNull(constructor, () -> "Constructor must not be null");
        try {
            return ReflectionUtil.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            return (T)ExceptionUtil.sneakyThrow(ExceptionUtil.getUnderlyingCause(t));
        }
    }

    public static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static boolean isClassVisibleInClassloader(Class<?> classToCheck, ClassLoader classLoader) {
        try {
            if (classToCheck.getClassLoader() == null) {
                return true;
            }
            if (classToCheck.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> loadedClass = classLoader.loadClass(classToCheck.getName());
            if (loadedClass == classToCheck) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

