/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import groovy.lang.MissingMethodException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.Checks;

public class TeePrintStream
extends PrintStream {
    private final PrintStream original;
    private final PrintStream delegate;
    private volatile boolean includeOriginal = true;

    public TeePrintStream(PrintStream original, PrintStream delegate) {
        super(new ByteArrayOutputStream(0));
        this.original = original;
        this.delegate = delegate;
    }

    @Deprecated
    public TeePrintStream(PrintStream ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Deprecated
    public TeePrintStream(List<PrintStream> delegates) {
        this(delegates.get(0), delegates.get(1));
        Checks.checkArgument(delegates.size() == 2, () -> "Only accepts two arguments");
    }

    @Deprecated
    public List<PrintStream> getDelegates() {
        return Arrays.asList(this.original, this.delegate);
    }

    public PrintStream getOriginal() {
        return this.original;
    }

    public PrintStream getDelegate() {
        return this.delegate;
    }

    public void muteOriginal() {
        this.includeOriginal = false;
    }

    public void unmuteOriginal() {
        this.includeOriginal = true;
    }

    @Deprecated
    public void stopDelegation() {
    }

    @Override
    public void flush() {
        if (this.includeOriginal) {
            this.original.flush();
        }
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.original.close();
        this.delegate.close();
    }

    @Override
    public boolean checkError() {
        return this.original.checkError() || this.delegate.checkError();
    }

    @Override
    protected void setError() {
        throw new UnsupportedOperationException("setError");
    }

    @Override
    protected void clearError() {
        for (PrintStream stream : Arrays.asList(this.original, this.delegate)) {
            try {
                GroovyRuntimeUtil.invokeMethod(stream, "clearError", new Object[0]);
            }
            catch (MissingMethodException e) {
                if ("clearError".equals(e.getMethod())) continue;
                throw e;
            }
        }
    }

    @Override
    public void write(int b) {
        if (this.includeOriginal) {
            this.original.write(b);
        }
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.includeOriginal) {
            this.original.write(buf, off, len);
        }
        this.delegate.write(buf, off, len);
    }

    @Override
    public void print(boolean b) {
        if (this.includeOriginal) {
            this.original.print(b);
        }
        this.delegate.print(b);
    }

    @Override
    public void print(char c) {
        if (this.includeOriginal) {
            this.original.print(c);
        }
        this.delegate.print(c);
    }

    @Override
    public void print(int i) {
        if (this.includeOriginal) {
            this.original.print(i);
        }
        this.delegate.print(i);
    }

    @Override
    public void print(long l) {
        if (this.includeOriginal) {
            this.original.print(l);
        }
        this.delegate.print(l);
    }

    @Override
    public void print(float f) {
        if (this.includeOriginal) {
            this.original.print(f);
        }
        this.delegate.print(f);
    }

    @Override
    public void print(double d) {
        if (this.includeOriginal) {
            this.original.print(d);
        }
        this.delegate.print(d);
    }

    @Override
    public void print(char[] s) {
        if (this.includeOriginal) {
            this.original.print(s);
        }
        this.delegate.print(s);
    }

    @Override
    public void print(String s) {
        if (this.includeOriginal) {
            this.original.print(s);
        }
        this.delegate.print(s);
    }

    @Override
    public void print(Object obj) {
        if (this.includeOriginal) {
            this.original.print(obj);
        }
        this.delegate.print(obj);
    }

    @Override
    public void println() {
        if (this.includeOriginal) {
            this.original.println();
        }
        this.delegate.println();
    }

    @Override
    public void println(boolean x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(char x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(int x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(long x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(float x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(double x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(char[] x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(String x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public void println(Object x) {
        if (this.includeOriginal) {
            this.original.println(x);
        }
        this.delegate.println(x);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        if (this.includeOriginal) {
            this.original.printf(format, args);
        }
        this.delegate.printf(format, args);
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        if (this.includeOriginal) {
            this.original.printf(l, format, args);
        }
        this.delegate.printf(l, format, args);
        return this;
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        if (this.includeOriginal) {
            this.original.printf(format, args);
        }
        this.delegate.printf(format, args);
        return this;
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        if (this.includeOriginal) {
            this.original.printf(format, args);
        }
        this.delegate.printf(format, args);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (this.includeOriginal) {
            this.original.append(csq);
        }
        this.delegate.append(csq);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        if (this.includeOriginal) {
            this.original.append(csq, start, end);
        }
        this.delegate.append(csq, start, end);
        return this;
    }

    @Override
    public PrintStream append(char c) {
        if (this.includeOriginal) {
            this.original.append(c);
        }
        this.delegate.append(c);
        return this;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.includeOriginal) {
            this.original.write(b);
        }
        this.delegate.write(b);
    }
}

