/*
 * Decompiled with CFR 0.152.
 */
package spock.mock;

import java.lang.reflect.Field;
import org.spockframework.mock.MockUtil;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Specification;
import spock.mock.AutoAttach;

public class AutoAttachExtension
implements IAnnotationDrivenExtension<AutoAttach> {
    private static final MockUtil MOCK_UTIL = new MockUtil();

    @Override
    public void visitFieldAnnotation(AutoAttach annotation, FieldInfo field) {
        if (field.isShared()) {
            throw new SpockException(String.format("@AutoAttach is only supported for instance fields (offending field: %s.%s)", ((Field)field.getReflection()).getDeclaringClass().getName(), field.getName()));
        }
        SpecInfo spec = (SpecInfo)field.getParent();
        spec.addSetupInterceptor(new AttachInterceptor(field));
        spec.addCleanupInterceptor(new DetachInterceptor(field));
    }

    private static class DetachInterceptor
    implements IMethodInterceptor {
        private final FieldInfo field;

        private DetachInterceptor(FieldInfo field) {
            this.field = field;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object mock = this.field.readValue(invocation.getInstance());
            MOCK_UTIL.detachMock(mock);
            invocation.proceed();
        }
    }

    private static class AttachInterceptor
    implements IMethodInterceptor {
        private final FieldInfo field;

        private AttachInterceptor(FieldInfo field) {
            this.field = field;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object mock = this.field.readValue(invocation.getInstance());
            if (mock == null) {
                throw new SpockException(String.format("Cannot AutoAttach 'null' for field %s:%s", this.field.getName(), this.field.getLine()));
            }
            if (!MOCK_UTIL.isMock(mock)) {
                throw new SpockException(String.format("AutoAttach failed '%s' is not a mock for field %s:%s", mock, this.field.getName(), this.field.getLine()));
            }
            MOCK_UTIL.attachMock(mock, (Specification)invocation.getInstance());
            invocation.proceed();
        }
    }
}

