/*
 * Decompiled with CFR 0.152.
 */
package spock.mock;

import java.util.Objects;
import java.util.regex.Pattern;
import org.spockframework.util.Checks;

public final class MockMakerId
implements Comparable<MockMakerId> {
    private static final Pattern VALID_ID = Pattern.compile("^[a-z][a-z0-9-]*+(?<!-)$");
    private final String id;

    public MockMakerId(String id) {
        Checks.notNull(id, () -> "The ID is null.");
        Checks.checkArgument(VALID_ID.matcher(id).matches(), () -> "The ID '" + id + "' is invalid. A valid ID must comply with the pattern: " + VALID_ID);
        this.id = id;
    }

    @Override
    public int compareTo(MockMakerId o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockMakerId that = (MockMakerId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

