/*
 * Decompiled with CFR 0.152.
 */
package spock.util.concurrent;

import groovy.lang.Closure;
import java.util.Locale;
import org.spockframework.lang.ConditionBlock;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.SpockTimeoutError;

public class PollingConditions {
    private double timeout = 1.0;
    private double initialDelay = 0.0;
    private double delay = 0.1;
    private double factor = 1.0;
    private Closure<String> timeoutMessage = null;

    public double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(double seconds) {
        this.timeout = seconds;
    }

    public double getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(double seconds) {
        this.initialDelay = seconds;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double seconds) {
        this.delay = seconds;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public void onTimeout(Closure<String> timeoutMessage) {
        this.timeoutMessage = timeoutMessage;
    }

    @ConditionBlock
    public void eventually(Closure<?> conditions) throws InterruptedException {
        this.within(this.timeout, conditions);
    }

    @ConditionBlock
    public void within(double seconds, Closure<?> conditions) throws InterruptedException {
        long timeoutMillis = this.toMillis(seconds);
        long start = System.currentTimeMillis();
        if (this.initialDelay > 0.0) {
            Thread.sleep(this.toMillis(this.initialDelay));
        }
        long currDelay = this.toMillis(this.delay);
        int attempts = 0;
        long elapsedTime = 0L;
        Throwable testException = null;
        while (elapsedTime <= timeoutMillis) {
            try {
                ++attempts;
                GroovyRuntimeUtil.invokeClosure(conditions, new Object[0]);
                return;
            }
            catch (Throwable e) {
                elapsedTime = System.currentTimeMillis() - start;
                testException = e;
                long sleepMillis = Math.min(currDelay, start + timeoutMillis - System.currentTimeMillis());
                if (sleepMillis > 0L) {
                    Thread.sleep(sleepMillis);
                }
                currDelay = (long)((double)currDelay * this.factor);
            }
        }
        String msg = String.format(Locale.ENGLISH, "Condition not satisfied after %1.2f seconds and %d attempts", (double)elapsedTime / 1000.0, attempts);
        if (this.timeoutMessage != null) {
            msg = String.format(Locale.ENGLISH, "%s: %s", msg, GroovyRuntimeUtil.invokeClosure(this.timeoutMessage, testException));
        }
        throw new SpockTimeoutError(seconds, msg, testException);
    }

    @ConditionBlock
    public void call(Closure<?> conditions) throws InterruptedException {
        this.eventually(conditions);
    }

    @ConditionBlock
    public void call(double seconds, Closure<?> conditions) throws InterruptedException {
        this.within(seconds, conditions);
    }

    private long toMillis(double seconds) {
        return (long)(seconds * 1000.0);
    }
}

