/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.BlockParseInfo;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.HelperMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.util.Identifiers;
import spock.lang.Shared;

public class SpecParser
implements GroovyClassVisitor {
    private final ErrorReporter errorReporter;
    private Spec spec;
    private int fieldCount = 0;
    private int featureMethodCount = 0;

    public SpecParser(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public Spec build(ClassNode clazz) {
        this.spec = new Spec(clazz);
        clazz.visitContents((GroovyClassVisitor)this);
        return this.spec;
    }

    public void visitClass(ClassNode clazz) {
        throw new UnsupportedOperationException("visitClass");
    }

    public void visitField(FieldNode gField) {
        PropertyNode owner = ((ClassNode)this.spec.getAst()).getProperty(gField.getName());
        if (gField.isStatic()) {
            return;
        }
        Field field = new Field(this.spec, gField, this.fieldCount++);
        field.setShared(AstUtil.hasAnnotation((ASTNode)gField, Shared.class));
        field.setOwner(owner);
        this.spec.getFields().add(field);
    }

    public void visitProperty(PropertyNode node) {
    }

    public void visitConstructor(ConstructorNode constructor) {
        if (constructor.hasNoRealSourcePosition()) {
            return;
        }
        this.errorReporter.error((ASTNode)constructor, "Constructors are not allowed; instead, define a 'setup()' or 'setupSpec()' method", new Object[0]);
    }

    public void visitMethod(MethodNode method) {
        if (this.isIgnoredMethod(method)) {
            return;
        }
        if (this.isFixtureMethod(method)) {
            this.buildFixtureMethod(method);
        } else if (this.isFeatureMethod(method)) {
            this.buildFeatureMethod(method);
        } else {
            this.buildHelperMethod(method);
        }
    }

    private boolean isIgnoredMethod(MethodNode method) {
        return AstUtil.isSynthetic(method);
    }

    private boolean isFixtureMethod(MethodNode method) {
        String name = method.getName();
        for (String fmName : Identifiers.FIXTURE_METHODS) {
            if (!fmName.equalsIgnoreCase(name)) continue;
            if (method.isStatic()) {
                this.errorReporter.error((ASTNode)method, "Fixture methods must not be static", new Object[0]);
            }
            if (!fmName.equals(name)) {
                this.errorReporter.error((ASTNode)method, "Misspelled '%s()' method (wrong capitalization)", fmName);
            }
            return true;
        }
        return false;
    }

    private void buildFixtureMethod(MethodNode method) {
        String name;
        FixtureMethod fixtureMethod = new FixtureMethod(this.spec, method);
        AnonymousBlock block = new AnonymousBlock(fixtureMethod);
        fixtureMethod.addBlock(block);
        List<Statement> stats = AstUtil.getStatements(method);
        ((List)block.getAst()).addAll(stats);
        stats.clear();
        switch (name = method.getName()) {
            case "setup": {
                this.spec.setSetupMethod(fixtureMethod);
                break;
            }
            case "cleanup": {
                this.spec.setCleanupMethod(fixtureMethod);
                break;
            }
            case "setupSpec": {
                this.spec.setSetupSpecMethod(fixtureMethod);
                break;
            }
            default: {
                this.spec.setCleanupSpecMethod(fixtureMethod);
            }
        }
    }

    private boolean isFeatureMethod(MethodNode method) {
        for (Statement stat : AstUtil.getStatements(method)) {
            String label = stat.getStatementLabel();
            if (label == null) continue;
            if (method.isStatic()) {
                this.errorReporter.error((ASTNode)method, "Feature methods must not be static", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void buildFeatureMethod(MethodNode method) {
        FeatureMethod feature = new FeatureMethod(this.spec, method, this.featureMethodCount++);
        try {
            this.buildBlocks(feature);
        }
        catch (InvalidSpecCompileException e) {
            this.errorReporter.error(e);
            return;
        }
        this.spec.getMethods().add(feature);
    }

    private void buildHelperMethod(MethodNode method) {
        HelperMethod helper = new HelperMethod(this.spec, method);
        this.spec.getMethods().add(helper);
        Block block = helper.addBlock(new AnonymousBlock(helper));
        List<Statement> stats = AstUtil.getStatements(method);
        ((List)block.getAst()).addAll(stats);
        stats.clear();
    }

    private void buildBlocks(Method method) throws InvalidSpecCompileException {
        List<Statement> stats = AstUtil.getStatements((MethodNode)method.getAst());
        Block currBlock = method.addBlock(new AnonymousBlock(method));
        String statementLabelToTransplant = null;
        for (Statement stat : stats) {
            if (stat.getStatementLabel() == null) {
                if (statementLabelToTransplant != null) {
                    stat.setStatementLabel(statementLabelToTransplant);
                }
                ((List)currBlock.getAst()).add(stat);
            } else {
                currBlock = this.addBlock(method, stat);
            }
            statementLabelToTransplant = this.getDescription(stat) == null ? null : stat.getStatementLabel();
        }
        this.checkIsValidSuccessor(method, BlockParseInfo.METHOD_END, ((MethodNode)method.getAst()).getLastLineNumber(), ((MethodNode)method.getAst()).getLastColumnNumber());
        int i = -1;
        for (Block block : method.getBlocks()) {
            if (!block.hasBlockMetadata()) continue;
            block.setBlockMetaDataIndex(++i);
        }
        stats.clear();
    }

    private Block addBlock(Method method, Statement stat) throws InvalidSpecCompileException {
        String label = stat.getStatementLabel();
        for (BlockParseInfo blockInfo : BlockParseInfo.values()) {
            if (!label.equals(blockInfo.toString())) continue;
            this.checkIsValidSuccessor(method, blockInfo, stat.getLineNumber(), stat.getColumnNumber());
            Block block = blockInfo.addNewBlock(method);
            String description = this.getDescription(stat);
            if (description == null) {
                ((List)block.getAst()).add(stat);
            } else {
                block.getDescriptions().add(description);
            }
            return block;
        }
        throw new InvalidSpecCompileException((ASTNode)stat, "Unrecognized block label: " + label, new Object[0]);
    }

    private String getDescription(Statement stat) {
        ConstantExpression constExpr = AstUtil.getExpression(stat, ConstantExpression.class);
        return constExpr == null || !(constExpr.getValue() instanceof String) ? null : (String)constExpr.getValue();
    }

    private void checkIsValidSuccessor(Method method, BlockParseInfo blockInfo, int line, int column) throws InvalidSpecCompileException {
        BlockParseInfo oldBlockInfo = method.getLastBlock().getParseInfo();
        if (!oldBlockInfo.getSuccessors(method).contains((Object)blockInfo)) {
            throw new InvalidSpecCompileException(line, column, "'%s' is not allowed here; instead, use one of: %s", new Object[]{blockInfo, oldBlockInfo.getSuccessors(method), method.getName(), oldBlockInfo, blockInfo});
        }
    }
}

