/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import groovy.transform.stc.SingleSignatureClosureHint;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.compiler.AstUtil;
import spock.mock.MockingApi;

public class ClosureParameterTypeFromVariableType
extends SingleSignatureClosureHint {
    private static final ClassNode MOCKING_API = new ClassNode(MockingApi.class);
    private static final ClassNode OBJECT = new ClassNode(Object.class);
    private static final Set<String> MOCK_METHODS = new HashSet<String>();

    public ClassNode[] getParameterTypes(MethodNode node, String[] options, SourceUnit sourceUnit, CompilationUnit unit, final ASTNode usage) {
        final ClassNode[] result = new ClassNode[]{OBJECT};
        sourceUnit.getAST().getClasses().stream().filter(cn -> cn.isDerivedFrom(MOCKING_API)).map(ClassNode::getMethods).flatMap(Collection::stream).map(MethodNode::getCode).forEach(code -> code.visit((GroovyCodeVisitor)new CodeVisitorSupport(){
            private final Deque currentDeclarations = new ArrayDeque();

            public void visitDeclarationExpression(DeclarationExpression expression) {
                if (expression.isMultipleAssignmentDeclaration()) {
                    super.visitDeclarationExpression(expression);
                } else {
                    this.currentDeclarations.push(expression);
                    try {
                        super.visitDeclarationExpression(expression);
                    }
                    finally {
                        this.currentDeclarations.pop();
                    }
                }
            }

            public void visitMethodCallExpression(MethodCallExpression call) {
                List<Expression> arguments;
                if (this.currentDeclarations.peek() != null && MOCK_METHODS.contains(call.getMethodAsString()) && (arguments = AstUtil.getArgumentList((Expression)call)).contains(usage)) {
                    result[0] = ((DeclarationExpression)this.currentDeclarations.peek()).getVariableExpression().getType();
                    return;
                }
                super.visitMethodCallExpression(call);
            }
        }));
        return new ClassNode[]{result[0]};
    }

    static {
        MOCK_METHODS.add("Mock");
        MOCK_METHODS.add("Stub");
        MOCK_METHODS.add("Spy");
        MOCK_METHODS.add("GroovyMock");
        MOCK_METHODS.add("GroovyStub");
        MOCK_METHODS.add("GroovySpy");
    }
}

