/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.runtime.Condition;
import org.spockframework.util.CollectionUtil;

public class EqualMethodNameConstraint
implements IInvocationConstraint {
    private final String methodName;

    public EqualMethodNameConstraint(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        return invocation.getMethod().getName().equals(this.methodName);
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        Condition condition = new Condition(CollectionUtil.listOf(invocation.getMethod().getName(), this.methodName, false), String.format("methodName == \"%s\"", this.methodName), null, null, null, null);
        return condition.getRendering();
    }
}

