/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.transform.Internal;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.codegen.Target;
import org.spockframework.mock.runtime.ByteBuddyInterceptorAdapter;
import org.spockframework.mock.runtime.ByteBuddyInvoker;
import org.spockframework.mock.runtime.ByteBuddyMockInteractionValidator;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockInstantiator;
import org.spockframework.util.ReflectionUtil;

class ByteBuddyMockFactory {
    private static final int CACHE_LOCK_MASK = 15;
    private static final int CACHE_LOCK_SIZE = 16;
    private static final Class<?> CODEGEN_TARGET_CLASS = Target.class;
    private static final String CODEGEN_PACKAGE = CODEGEN_TARGET_CLASS.getPackage().getName();
    private static final AnnotationDescription INTERNAL_ANNOTATION = AnnotationDescription.Builder.ofType(Internal.class).build();
    private static final Method MOCK_INTERACTION_VALIDATOR_METHOD = Objects.requireNonNull(ReflectionUtil.getMethodByName(ISpockMockObject.class, "$spock_mockInteractionValidator"));
    private final TypeCachingLock[] cacheLocks;
    private final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);

    ByteBuddyMockFactory() {
        this.cacheLocks = new TypeCachingLock[16];
        for (int i = 0; i < 16; ++i) {
            this.cacheLocks[i] = new TypeCachingLock();
        }
    }

    @VisibleForTesting
    static boolean isLocalMock(Class<?> targetClass, Collection<Class<?>> additionalInterfaces) {
        ClassLoader cl = new MultipleParentClassLoader.Builder().appendMostSpecific(new Class[]{targetClass}).appendMostSpecific(additionalInterfaces).appendMostSpecific(new Class[]{ISpockMockObject.class}).build();
        return cl == targetClass.getClassLoader();
    }

    Object createMock(IMockMaker.IMockCreationSettings settings) {
        Class<?> type = settings.getMockType();
        TypeCache.SimpleKey key = new TypeCache.SimpleKey(type, settings.getAdditionalInterface());
        ClassLoader classLoader = settings.getClassLoader();
        Class enhancedType = this.CACHE.findOrInsert(classLoader, (Object)key, () -> {
            String typeName = type.getName();
            Class<?> targetClass = type;
            if (ByteBuddyMockFactory.shouldLoadIntoCodegenPackage(type)) {
                typeName = CODEGEN_PACKAGE + "." + type.getSimpleName();
                targetClass = CODEGEN_TARGET_CLASS;
            }
            int randomNumber = Math.abs(ThreadLocalRandom.current().nextInt());
            String name = String.format("%s$%s$%d", typeName, "SpockMock", randomNumber);
            ClassLoadingStrategy<ClassLoader> strategy = ByteBuddyMockFactory.determineBestClassLoadingStrategy(targetClass, settings);
            return new ByteBuddy().with(TypeValidation.DISABLED).ignore((ElementMatcher)ElementMatchers.none()).subclass(type).name(name).implement(settings.getAdditionalInterface()).implement(new Type[]{ISpockMockObject.class}).method(m -> ByteBuddyMockFactory.isGroovyMOPMethod(type, m)).intercept((Implementation)ByteBuddyMockFactory.mockInterceptor()).transform(ByteBuddyMockFactory.mockTransformer()).annotateMethod(new AnnotationDescription[]{INTERNAL_ANNOTATION}).method(m -> !ByteBuddyMockFactory.isGroovyMOPMethod(type, m)).intercept((Implementation)ByteBuddyMockFactory.mockInterceptor()).transform(ByteBuddyMockFactory.mockTransformer()).method(m -> m.represents(MOCK_INTERACTION_VALIDATOR_METHOD)).intercept((Implementation)FixedValue.reference((Object)new ByteBuddyMockInteractionValidator(), (String)"$spock_mockInteractionValidator")).transform(ByteBuddyMockFactory.validateMockInteractionTransformer()).implement(new Type[]{ByteBuddyInterceptorAdapter.InterceptorAccess.class}).intercept((Implementation)FieldAccessor.ofField((String)"$spock_interceptor")).defineField("$spock_interceptor", IProxyBasedMockInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, SyntheticState.SYNTHETIC}).make().load(classLoader, strategy).getLoaded();
        }, (Object)this.getCacheLockForKey(key));
        Object proxy = MockInstantiator.instantiate(type, enhancedType, settings.getConstructorArgs(), settings.isUseObjenesis());
        ((ByteBuddyInterceptorAdapter.InterceptorAccess)proxy).$spock_set(settings.getMockInterceptor());
        return proxy;
    }

    private static Transformer<MethodDescription> validateMockInteractionTransformer() {
        return Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN, Visibility.PUBLIC, MethodManifestation.FINAL});
    }

    private static Transformer<MethodDescription> mockTransformer() {
        return Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN, Visibility.PUBLIC});
    }

    private static MethodDelegation mockInterceptor() {
        return MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(ByteBuddyInvoker.class)}).to(ByteBuddyInterceptorAdapter.class);
    }

    private static boolean isGroovyMOPMethod(Class<?> type, MethodDescription method) {
        return GroovyObject.class.isAssignableFrom(type) && method.getDeclaredAnnotations().isAnnotationPresent(Internal.class) && method.isDefaultMethod();
    }

    private TypeCachingLock getCacheLockForKey(TypeCache.SimpleKey key) {
        int hashCode = key.hashCode();
        hashCode ^= hashCode >>> 16;
        int index = hashCode & 0xF;
        return this.cacheLocks[index];
    }

    private static boolean shouldLoadIntoCodegenPackage(Class<?> type) {
        return ByteBuddyMockFactory.isComingFromJDK(type) || ByteBuddyMockFactory.isComingFromSignedJar(type) || ByteBuddyMockFactory.isComingFromSealedPackage(type);
    }

    private static boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private static boolean isComingFromSealedPackage(Class<?> type) {
        return type.getPackage() != null && type.getPackage().isSealed();
    }

    private static boolean isComingFromSignedJar(Class<?> type) {
        return type.getSigners() != null;
    }

    @NotNull
    private static ClassLoadingStrategy<ClassLoader> determineBestClassLoadingStrategy(Class<?> targetClass, IMockMaker.IMockCreationSettings settings) throws Exception {
        if (ClassInjector.UsingLookup.isAvailable() && ByteBuddyMockFactory.isLocalMock(targetClass, settings.getAdditionalInterface())) {
            Class<?> methodHandlesClass = Class.forName("java.lang.invoke.MethodHandles");
            Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
            Method lookupMethod = methodHandlesClass.getMethod("lookup", new Class[0]);
            Method privateLookupInMethod = methodHandlesClass.getMethod("privateLookupIn", Class.class, lookupClass);
            Object lookup = lookupMethod.invoke(null, new Object[0]);
            Object privateLookup = privateLookupInMethod.invoke(null, targetClass, lookup);
            return ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
        }
        if (ClassInjector.UsingReflection.isAvailable()) {
            return ClassLoadingStrategy.Default.INJECTION;
        }
        return ClassLoadingStrategy.Default.WRAPPER;
    }

    private static final class TypeCachingLock {
        private TypeCachingLock() {
        }
    }
}

