/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.runtime.CglibMockFactory;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.JavaProxyMockMaker;
import org.spockframework.util.ReflectionUtil;
import spock.mock.MockMakerId;
import spock.util.environment.Jvm;

public class CglibMockMaker
implements IMockMaker {
    public static final MockMakerId ID = new MockMakerId("cglib");
    private static final boolean cglibAvailable = ReflectionUtil.isClassAvailable("net.sf.cglib.proxy.Enhancer");
    private static final Set<IMockMaker.MockMakerCapability> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(IMockMaker.MockMakerCapability.INTERFACE, IMockMaker.MockMakerCapability.CLASS, IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES, IMockMaker.MockMakerCapability.EXPLICIT_CONSTRUCTOR_ARGUMENTS));

    @Override
    public MockMakerId getId() {
        return ID;
    }

    @Override
    public Set<IMockMaker.MockMakerCapability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getPriority() {
        return 300;
    }

    @Override
    public Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        return CglibMockFactory.createMock(settings);
    }

    @Override
    public IMockMaker.IMockabilityResult getMockability(IMockMaker.IMockCreationSettings settings) {
        if (!cglibAvailable) {
            return () -> "The cglib-nodep library is missing on the class path.";
        }
        if (Jvm.getCurrent().isJava21Compatible()) {
            return () -> "Mocking with cglib is not supported on Java 21 or newer.";
        }
        return JavaProxyMockMaker.checkMockClassesAreVisibleInClassloader(settings);
    }
}

