/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.List;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.MockNature;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import spock.mock.IMockMakerSettings;
import spock.mock.MockMakerId;

public interface IMockMaker {
    public MockMakerId getId();

    public Set<MockMakerCapability> getCapabilities();

    public int getPriority();

    public Object makeMock(IMockCreationSettings var1) throws CannotCreateMockException;

    default public IStaticMock makeStaticMock(IMockCreationSettings settings) throws CannotCreateMockException {
        throw new UnsupportedOperationException("Operation not implemented by " + this.getId() + ", but claimed capability MockMakerCapability.STATIC_METHOD. Settings: " + settings);
    }

    public IMockabilityResult getMockability(IMockCreationSettings var1);

    default public IMockObject asMockOrNull(Object object) {
        return null;
    }

    default public boolean isStaticMock(Class<?> clazz) {
        return false;
    }

    public static interface IStaticMock {
        public Class<?> getType();

        public void enable();

        public void disable();
    }

    public static enum MockMakerCapability {
        INTERFACE("Cannot mock interfaces."),
        CLASS("Cannot mock classes."),
        ADDITIONAL_INTERFACES("Cannot mock classes with additional interfaces."),
        EXPLICIT_CONSTRUCTOR_ARGUMENTS("Explicit constructor arguments are not supported."),
        FINAL_CLASS("Cannot mock final classes."),
        FINAL_METHOD("Cannot mock final methods."),
        STATIC_METHOD("Cannot mock static methods.");

        private final IMockabilityResult notMockable = () -> errorMessage;

        private MockMakerCapability(String errorMessage) {
        }

        IMockabilityResult notMockable() {
            return this.notMockable;
        }
    }

    public static interface IMockCreationSettings {
        public Class<?> getMockType();

        public MockNature getMockNature();

        public List<Class<?>> getAdditionalInterface();

        public List<Object> getConstructorArgs();

        public IProxyBasedMockInterceptor getMockInterceptor();

        public ClassLoader getClassLoader();

        public boolean isUseObjenesis();

        public boolean isStaticMock();

        public <T extends IMockMakerSettings> T getMockMakerSettings();
    }

    @FunctionalInterface
    public static interface IMockabilityResult {
        public static final IMockabilityResult MOCKABLE = new IMockabilityResult(){

            @Override
            public boolean isMockable() {
                return true;
            }

            @Override
            public String getNotMockableReason() {
                return "";
            }
        };

        default public boolean isMockable() {
            return false;
        }

        public String getNotMockableReason();
    }
}

