/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.IMockMaker;
import org.spockframework.mock.runtime.JavaProxyMockInterceptorAdapter;
import org.spockframework.util.ReflectionUtil;
import spock.mock.MockMakerId;

public class JavaProxyMockMaker
implements IMockMaker {
    public static final MockMakerId ID = new MockMakerId("java-proxy");
    private static final Class<?>[] CLASSES = new Class[0];
    private static final Set<IMockMaker.MockMakerCapability> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(IMockMaker.MockMakerCapability.INTERFACE, IMockMaker.MockMakerCapability.ADDITIONAL_INTERFACES));

    @Override
    public MockMakerId getId() {
        return ID;
    }

    @Override
    public Set<IMockMaker.MockMakerCapability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Object makeMock(IMockMaker.IMockCreationSettings settings) throws CannotCreateMockException {
        return this.createMock(settings);
    }

    private Object createMock(IMockMaker.IMockCreationSettings settings) {
        ArrayList interfaces = new ArrayList();
        interfaces.add(settings.getMockType());
        interfaces.addAll(settings.getAdditionalInterface());
        interfaces.add(ISpockMockObject.class);
        return Proxy.newProxyInstance(settings.getClassLoader(), interfaces.toArray(CLASSES), (InvocationHandler)new JavaProxyMockInterceptorAdapter(settings.getMockInterceptor()));
    }

    @Override
    public IMockMaker.IMockabilityResult getMockability(IMockMaker.IMockCreationSettings settings) {
        return JavaProxyMockMaker.checkMockClassesAreVisibleInClassloader(settings);
    }

    static IMockMaker.IMockabilityResult checkMockClassesAreVisibleInClassloader(IMockMaker.IMockCreationSettings settings) {
        ClassLoader classLoader = settings.getClassLoader();
        IMockMaker.IMockabilityResult result = JavaProxyMockMaker.checkIfClassIsVisible(settings.getMockType(), classLoader);
        if (!result.isMockable()) {
            return result;
        }
        result = JavaProxyMockMaker.checkIfClassIsVisible(ISpockMockObject.class, classLoader);
        if (!result.isMockable()) {
            return result;
        }
        for (Class<?> ifClass : settings.getAdditionalInterface()) {
            result = JavaProxyMockMaker.checkIfClassIsVisible(ifClass, classLoader);
            if (result.isMockable()) continue;
            return result;
        }
        return IMockMaker.IMockabilityResult.MOCKABLE;
    }

    private static IMockMaker.IMockabilityResult checkIfClassIsVisible(Class<?> mockType, ClassLoader classLoader) {
        if (!ReflectionUtil.isClassVisibleInClassloader(mockType, classLoader)) {
            return () -> "The class " + mockType.getName() + " is not visible by the classloader " + classLoader + ".";
        }
        return IMockMaker.IMockabilityResult.MOCKABLE;
    }
}

