/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Type;
import java.util.Objects;
import org.spockframework.lang.Wildcard;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.runtime.SpecificationAttachable;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.util.GenericTypeReflectorUtil;
import spock.lang.Specification;

public class MockObject
implements IMockObject {
    private final IMockConfiguration configuration;
    private final Object instance;
    private final SpecificationAttachable mockInterceptor;
    private Specification specification;

    public MockObject(IMockConfiguration configuration, Object instance, Specification specification, SpecificationAttachable mockInterceptor) {
        this.configuration = Objects.requireNonNull(configuration);
        this.instance = instance;
        this.specification = specification;
        this.mockInterceptor = mockInterceptor;
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    @Override
    public String getMockName() {
        return this.getName() != null ? this.getName() : "unnamed";
    }

    @Override
    public Class<?> getType() {
        return GenericTypeReflectorUtil.erase(this.getExactType());
    }

    @Override
    public Type getExactType() {
        return this.configuration.getExactType();
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public boolean isVerified() {
        return this.configuration.isVerified();
    }

    private boolean isGlobal() {
        return this.configuration.isGlobal();
    }

    @Override
    public IDefaultResponse getDefaultResponse() {
        return this.configuration.getDefaultResponse();
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public boolean matches(Object target, IMockInteraction interaction) {
        boolean match;
        if (target instanceof Wildcard) {
            return this.isVerified() || !interaction.isRequired();
        }
        boolean bl = this.isGlobal() ? this.matchGlobal(target) : (match = this.instance == target);
        if (match) {
            this.checkRequiredInteractionAllowed(interaction);
        }
        return match;
    }

    private boolean matchGlobal(Object target) {
        return this.instance.getClass() == target.getClass() && (!this.isMockOfClass() || this.instance == target);
    }

    private boolean isMockOfClass() {
        return this.instance instanceof Class;
    }

    private void checkRequiredInteractionAllowed(IMockInteraction interaction) {
        if (!this.isVerified() && interaction.isRequired()) {
            throw new InvalidSpecException("Stub '%s' matches the following required interaction:\n\n%s\n\nRemove the cardinality (e.g. '1 *'), or turn the stub into a mock.\n").withArgs(this.getMockName(), interaction);
        }
    }

    @Override
    public void attach(Specification spec) {
        this.specification = spec;
        this.mockInterceptor.attach(spec);
    }

    @Override
    public void detach() {
        this.specification = null;
        this.mockInterceptor.detach();
    }

    @Override
    public IMockConfiguration getConfiguration() {
        return this.configuration;
    }
}

