/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.DummyStackTraceFilter;
import org.spockframework.runtime.ErrorContext;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.IDataIterator;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.StackTraceFilter;
import org.spockframework.runtime.model.DataProcessorMetadata;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.DataVariableMultiplication;
import org.spockframework.runtime.model.DataVariableMultiplicationFactor;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IErrorContext;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Assert;
import spock.config.RunnerConfiguration;

public class DataIteratorFactory {
    public static final int UNKNOWN_ITERATIONS = -1;
    protected final IRunSupervisor supervisor;

    public DataIteratorFactory(IRunSupervisor supervisor) {
        this.supervisor = supervisor;
    }

    public IDataIterator createFeatureDataIterator(SpockExecutionContext context) {
        if (context.getCurrentFeature().getDataProcessorMethod() == null) {
            return new SingleEmptyIterationDataIterator();
        }
        return new IterationFilterIterator(this.supervisor, context, new DataProcessorIterator(this.supervisor, context, new FeatureDataProviderIterator(this.supervisor, context)));
    }

    private static class DataProviderMultiplier
    extends BaseDataIterator {
        private final List<String> dataVariableNames;
        private final List<DataProviderInfo> multiplierProviderInfos;
        private final List<DataProviderInfo> multiplicandProviderInfos;
        private final DataProviderMultiplier multiplierProvider;
        private final Object[] multiplierProviders;
        private final Object[] multiplicandProviders;
        private final Iterator<?>[] multiplierIterators;
        private final Iterator<?>[] multiplicandIterators;
        private Object[] currentMultiplierValues = null;
        private boolean collectMultiplicandValues = true;
        private final List<List<Object>> collectedMultiplicandValues;
        private final int estimatedNumIterations;
        private final int processedDataProviders;

        public DataProviderMultiplier(IRunSupervisor supervisor, SpockExecutionContext context, List<String> dataVariableNames, List<DataProviderInfo> multiplierProviderInfos, List<DataProviderInfo> multiplicandProviderInfos, Object[] multiplierProviders, Object[] multiplicandProviders) {
            super(supervisor, context);
            this.dataVariableNames = Objects.requireNonNull(dataVariableNames);
            this.multiplierProviderInfos = multiplierProviderInfos;
            this.multiplicandProviderInfos = multiplicandProviderInfos;
            this.multiplierProvider = null;
            this.multiplierProviders = multiplierProviders;
            this.multiplicandProviders = multiplicandProviders;
            this.collectedMultiplicandValues = this.createMultiplicandStorage();
            this.multiplierIterators = this.createIterators(this.multiplierProviders, this.multiplierProviderInfos);
            this.multiplicandIterators = this.createIterators(this.multiplicandProviders, this.multiplicandProviderInfos);
            if (this.multiplicandIterators != null) {
                Assert.that(multiplicandProviderInfos.size() == this.multiplicandIterators.length);
            }
            int estimatedMultiplierIterations = this.estimateNumIterations(Objects.requireNonNull(multiplierProviders));
            int estimatedMultiplicandIterations = this.estimateNumIterations(Objects.requireNonNull(multiplicandProviders));
            this.estimatedNumIterations = estimatedMultiplierIterations == -1 || estimatedMultiplicandIterations == -1 ? -1 : estimatedMultiplierIterations * estimatedMultiplicandIterations;
            this.processedDataProviders = multiplierProviders.length + multiplicandProviders.length;
        }

        public DataProviderMultiplier(IRunSupervisor supervisor, SpockExecutionContext context, List<String> dataVariableNames, List<DataProviderInfo> multiplierProviderInfos, List<DataProviderInfo> multiplicandProviderInfos, DataProviderMultiplier multiplierProvider, Object[] multiplicandProviders) {
            super(supervisor, context);
            this.dataVariableNames = Objects.requireNonNull(dataVariableNames);
            this.multiplierProviderInfos = multiplierProviderInfos;
            this.multiplicandProviderInfos = multiplicandProviderInfos;
            this.multiplierProvider = multiplierProvider;
            this.multiplierProviders = null;
            this.multiplicandProviders = multiplicandProviders;
            this.collectedMultiplicandValues = this.createMultiplicandStorage();
            this.multiplierIterators = new Iterator[]{multiplierProvider};
            this.multiplicandIterators = this.createIterators(this.multiplicandProviders, this.multiplicandProviderInfos);
            if (this.multiplicandIterators != null) {
                Assert.that(multiplicandProviderInfos.size() == this.multiplicandIterators.length);
            }
            int estimatedMultiplierIterations = Objects.requireNonNull(multiplierProvider).getEstimatedNumIterations();
            int estimatedMultiplicandIterations = this.estimateNumIterations(Objects.requireNonNull(multiplicandProviders));
            this.estimatedNumIterations = estimatedMultiplierIterations == -1 || estimatedMultiplicandIterations == -1 ? -1 : estimatedMultiplierIterations * estimatedMultiplicandIterations;
            this.processedDataProviders = multiplierProvider.getProcessedDataProviders() + multiplicandProviders.length;
        }

        private List<List<Object>> createMultiplicandStorage() {
            ArrayList<List<Object>> result = new ArrayList<List<Object>>(this.multiplicandProviders.length);
            for (int i = 0; i < this.multiplicandProviders.length; ++i) {
                result.add(new ArrayList());
            }
            return result;
        }

        @Override
        public void close() throws Exception {
            GroovyRuntimeUtil.closeQuietly(this.multiplierProvider);
            GroovyRuntimeUtil.closeQuietly(this.multiplierProviders);
            GroovyRuntimeUtil.closeQuietly(this.multiplicandProviders);
        }

        @Override
        public boolean hasNext() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return false;
            }
            return this.haveNext(this.multiplicandIterators, this.multiplicandProviderInfos) || this.haveNext(this.multiplierIterators, this.multiplierProviderInfos);
        }

        @Override
        public Object[] next() {
            Object[] nextMultiplicandValues;
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            if (!this.haveNext(this.multiplicandIterators, this.multiplicandProviderInfos)) {
                this.currentMultiplierValues = this.extractNextValues(this.multiplierIterators, this.multiplierProviderInfos);
                if (this.currentMultiplierValues == null) {
                    return null;
                }
                if (this.multiplierProvider != null) {
                    this.currentMultiplierValues = (Object[])this.currentMultiplierValues[0];
                }
                this.collectMultiplicandValues = false;
                for (int i = 0; i < this.multiplicandIterators.length; ++i) {
                    try {
                        this.multiplicandIterators[i] = this.collectedMultiplicandValues.get(i).iterator();
                        continue;
                    }
                    catch (Throwable t) {
                        this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.multiplicandProviderInfos.get(i).getDataProviderMethod(), t, this.getErrorContext()));
                        return null;
                    }
                }
            }
            if (this.currentMultiplierValues == null) {
                this.currentMultiplierValues = this.extractNextValues(this.multiplierIterators, this.multiplierProviderInfos);
                if (this.currentMultiplierValues == null) {
                    return null;
                }
                if (this.multiplierProvider != null) {
                    this.currentMultiplierValues = (Object[])this.currentMultiplierValues[0];
                }
            }
            if ((nextMultiplicandValues = this.extractNextValues(this.multiplicandIterators, this.multiplicandProviderInfos)) == null) {
                return null;
            }
            if (this.collectMultiplicandValues) {
                for (int i = 0; i < nextMultiplicandValues.length; ++i) {
                    this.collectedMultiplicandValues.get(i).add(nextMultiplicandValues[i]);
                }
            }
            Object[] next = new Object[this.currentMultiplierValues.length + nextMultiplicandValues.length];
            System.arraycopy(this.currentMultiplierValues, 0, next, 0, this.currentMultiplierValues.length);
            System.arraycopy(nextMultiplicandValues, 0, next, this.currentMultiplierValues.length, nextMultiplicandValues.length);
            return next;
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.estimatedNumIterations;
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        public int getProcessedDataProviders() {
            return this.processedDataProviders;
        }

        private Iterator<?>[] createIterators(Object[] dataProviders, List<DataProviderInfo> dataProviderInfos) {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            Assert.that(dataProviders.length == dataProviderInfos.size());
            Iterator[] iterators = new Iterator[dataProviders.length];
            for (int i = 0; i < dataProviders.length; ++i) {
                Iterator<?> iter = this.createIterator(dataProviders[i], dataProviderInfos.get(i));
                if (iter == null) {
                    return null;
                }
                iterators[i] = iter;
            }
            return iterators;
        }

        protected Object[] extractNextValues(Iterator<?>[] iterators, List<DataProviderInfo> providerInfos) {
            Assert.that(iterators.length == providerInfos.size());
            Object[] result = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                try {
                    result[i] = iterators[i].next();
                    continue;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(providerInfos.get(i).getDataProviderMethod(), t, this.getErrorContext()));
                    return null;
                }
            }
            return result;
        }
    }

    private static class DataProviderIterator
    extends BaseDataIterator {
        private final List<String> dataVariableNames;
        private final DataProviderInfo providerInfo;
        private final Object provider;
        private final Iterator<?> iterator;
        private final int estimatedNumIterations;

        public DataProviderIterator(IRunSupervisor supervisor, SpockExecutionContext context, String dataVariableName, DataProviderInfo providerInfo, Object provider) {
            super(supervisor, context);
            this.dataVariableNames = Collections.singletonList(Objects.requireNonNull(dataVariableName));
            this.estimatedNumIterations = this.estimateNumIterations(provider);
            this.providerInfo = Objects.requireNonNull(providerInfo);
            this.provider = Objects.requireNonNull(provider);
            this.iterator = this.createIterator(provider, providerInfo);
        }

        @Override
        public void close() throws Exception {
            GroovyRuntimeUtil.closeQuietly(this.provider);
        }

        @Override
        public boolean hasNext() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return false;
            }
            try {
                return this.iterator.hasNext();
            }
            catch (Throwable t) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.providerInfo.getDataProviderMethod(), t, this.getErrorContext()));
                return false;
            }
        }

        @Override
        public Object[] next() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            try {
                return new Object[]{this.iterator.next()};
            }
            catch (Throwable t) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.providerInfo.getDataProviderMethod(), t, this.getErrorContext()));
                return null;
            }
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.estimatedNumIterations;
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }
    }

    private static class FeatureDataProviderIterator
    extends BaseDataIterator {
        private final Object[] dataProviders;
        private final IDataIterator[] dataProviderIterators;
        private final int estimatedNumIterations;
        private final List<String> dataVariableNames = this.dataVariableNames();
        private boolean firstIteration = true;

        public FeatureDataProviderIterator(IRunSupervisor supervisor, SpockExecutionContext context) {
            super(supervisor, context);
            this.dataProviders = this.createDataProviders();
            this.dataProviderIterators = this.createDataProviderIterators();
            if (this.dataProviderIterators != null && this.dataProviders != null) {
                Assert.that(this.dataProviderIterators.length == this.dataProviders.length);
            }
            this.estimatedNumIterations = this.estimateNumIterations(this.dataProviderIterators);
        }

        @Override
        public void close() {
            GroovyRuntimeUtil.closeQuietly(this.dataProviders);
            GroovyRuntimeUtil.closeQuietly(this.dataProviderIterators);
        }

        @Override
        public boolean hasNext() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return false;
            }
            if (this.dataProviderIterators.length == 0 && !this.firstIteration) {
                return false;
            }
            return this.haveNext(this.dataProviderIterators, this.context.getCurrentFeature().getDataProviders());
        }

        @Override
        public Object[] next() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            Assert.that(this.dataProviders.length == this.context.getCurrentFeature().getDataProviders().size());
            this.firstIteration = false;
            Object[] next = new Object[this.dataProviders.length];
            int i = 0;
            while (i < this.dataProviders.length) {
                try {
                    if (this.dataProviderIterators[i] == null) continue;
                    if (!this.dataProviderIterators[i].hasNext()) {
                        return null;
                    }
                    Object[] nextValues = (Object[])this.dataProviderIterators[i].next();
                    if (nextValues == null) {
                        return null;
                    }
                    System.arraycopy(nextValues, 0, next, i, nextValues.length);
                    i += nextValues.length;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t, this.getErrorContext()));
                    return null;
                }
            }
            return next;
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.estimatedNumIterations;
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        private Object[] createDataProviders() {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            List<DataProviderInfo> dataProviderInfos = this.context.getCurrentFeature().getDataProviders();
            if (dataProviderInfos.isEmpty()) {
                return new Object[0];
            }
            Object[] dataProviders = new Object[dataProviderInfos.size()];
            int size = dataProviderInfos.size();
            for (int i = 0; i < size; ++i) {
                DataProviderInfo dataProviderInfo = dataProviderInfos.get(i);
                MethodInfo method = dataProviderInfo.getDataProviderMethod();
                Object provider = this.invokeRaw(this.context.getCurrentInstance(), method, this.getPreviousDataTableProviders(this.dataVariableNames, dataProviders, dataProviderInfo));
                if (this.context.getErrorInfoCollector().hasErrors()) {
                    if (provider == null) break;
                    dataProviders[i] = provider;
                    break;
                }
                if (provider == null) {
                    SpockExecutionException error = new SpockExecutionException("Data provider is null!");
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(method, error, this.getErrorContext()));
                    break;
                }
                dataProviders[i] = provider;
            }
            return dataProviders;
        }

        private IDataIterator[] createDataProviderIterators() {
            DataVariableMultiplication nextDataVariableMultiplication;
            Iterator dataVariableMultiplications;
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            MethodInfo dataVariableMultiplicationsMethod = this.context.getCurrentFeature().getDataVariableMultiplicationsMethod();
            if (dataVariableMultiplicationsMethod != null) {
                try {
                    dataVariableMultiplications = Arrays.stream((DataVariableMultiplication[])this.invokeRaw(null, dataVariableMultiplicationsMethod, new Object[0])).iterator();
                    nextDataVariableMultiplication = (DataVariableMultiplication)dataVariableMultiplications.next();
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(dataVariableMultiplicationsMethod, t, this.getErrorContext()));
                    return null;
                }
            } else {
                dataVariableMultiplications = Collections.emptyIterator();
                nextDataVariableMultiplication = null;
            }
            List<DataProviderInfo> dataProviderInfos = this.context.getCurrentFeature().getDataProviders();
            IDataIterator[] dataIterators = new IDataIterator[this.dataProviders.length];
            int dataProviderIndex = 0;
            int dataVariableNameIndex = 0;
            while (dataProviderIndex < this.dataProviders.length) {
                String nextDataVariableName = this.dataVariableNames.get(dataVariableNameIndex);
                if (nextDataVariableMultiplication != null && nextDataVariableMultiplication.getDataVariables()[0].equals(nextDataVariableName)) {
                    dataIterators[dataProviderIndex] = this.createDataProviderMultiplier(nextDataVariableMultiplication, dataProviderIndex);
                    int remainingVariables = nextDataVariableMultiplication.getDataVariables().length;
                    dataVariableNameIndex += remainingVariables - 1;
                    while (remainingVariables > 0) {
                        remainingVariables -= dataProviderInfos.get(dataProviderIndex).getDataVariables().size();
                        ++dataProviderIndex;
                    }
                    --dataProviderIndex;
                    Assert.that(remainingVariables == 0);
                    nextDataVariableMultiplication = dataVariableMultiplications.hasNext() ? (DataVariableMultiplication)dataVariableMultiplications.next() : null;
                } else {
                    DataProviderInfo dataProviderInfo = dataProviderInfos.get(dataProviderIndex);
                    dataIterators[dataProviderIndex] = new DataProviderIterator(this.supervisor, this.context, nextDataVariableName, dataProviderInfo, this.dataProviders[dataProviderIndex]);
                    dataVariableNameIndex += dataProviderInfo.getDataVariables().size() - 1;
                }
                ++dataProviderIndex;
                ++dataVariableNameIndex;
            }
            return dataIterators;
        }

        private DataProviderMultiplier createDataProviderMultiplier(DataVariableMultiplication dataVariableMultiplication, int dataProviderOffset) {
            DataVariableMultiplicationFactor multiplier = dataVariableMultiplication.getMultiplier();
            DataVariableMultiplicationFactor multiplicand = dataVariableMultiplication.getMultiplicand();
            if (multiplier instanceof DataVariableMultiplication) {
                DataProviderMultiplier multiplierProvider = this.createDataProviderMultiplier((DataVariableMultiplication)multiplier, dataProviderOffset);
                ArrayList<DataProviderInfo> multiplicandProviderInfos = new ArrayList<DataProviderInfo>();
                ArrayList<Object> multiplicandProviders = new ArrayList<Object>();
                this.collectDataProviders(dataProviderOffset + multiplierProvider.getProcessedDataProviders(), multiplicand, multiplicandProviderInfos, multiplicandProviders);
                return new DataProviderMultiplier(this.supervisor, this.context, Arrays.asList(dataVariableMultiplication.getDataVariables()), multiplierProvider.multiplierProviderInfos.subList(0, 1), multiplicandProviderInfos, multiplierProvider, multiplicandProviders.toArray(new Object[0]));
            }
            ArrayList<DataProviderInfo> multiplierProviderInfos = new ArrayList<DataProviderInfo>();
            ArrayList<DataProviderInfo> multiplicandProviderInfos = new ArrayList<DataProviderInfo>();
            ArrayList<Object> multiplierProviders = new ArrayList<Object>();
            ArrayList<Object> multiplicandProviders = new ArrayList<Object>();
            this.collectDataProviders(dataProviderOffset, multiplier, multiplierProviderInfos, multiplierProviders);
            this.collectDataProviders(dataProviderOffset + multiplierProviderInfos.size(), multiplicand, multiplicandProviderInfos, multiplicandProviders);
            return new DataProviderMultiplier(this.supervisor, this.context, Arrays.asList(dataVariableMultiplication.getDataVariables()), multiplierProviderInfos, multiplicandProviderInfos, multiplierProviders.toArray(new Object[0]), multiplicandProviders.toArray(new Object[0]));
        }

        private void collectDataProviders(int dataProviderOffset, DataVariableMultiplicationFactor factor, List<DataProviderInfo> factorProviderInfos, List<Object> factorProviders) {
            int factorDataVariables;
            int remainingDataVariables;
            DataProviderInfo dataProviderInfo;
            List<DataProviderInfo> dataProviderInfos = this.context.getCurrentFeature().getDataProviders();
            for (remainingDataVariables = factorDataVariables = factor.getDataVariables().length; remainingDataVariables > 0; remainingDataVariables -= dataProviderInfo.getDataVariables().size()) {
                int dataProviderIndex = dataProviderOffset + factorDataVariables - remainingDataVariables;
                dataProviderInfo = dataProviderInfos.get(dataProviderIndex);
                factorProviderInfos.add(dataProviderInfo);
                factorProviders.add(this.dataProviders[dataProviderIndex]);
            }
            Assert.that(remainingDataVariables == 0);
        }

        @NotNull
        private List<String> dataVariableNames() {
            return this.context.getCurrentFeature().getDataProviders().stream().map(DataProviderInfo::getDataVariables).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Object[] getPreviousDataTableProviders(List<String> dataProviderVariables, Object[] dataProviders, DataProviderInfo dataProviderInfo) {
            ArrayList<Object> result = new ArrayList<Object>();
            block0: for (String previousDataTableVariable : dataProviderInfo.getPreviousDataTableVariables()) {
                int size = dataProviderVariables.size();
                for (int i = 0; i < size; ++i) {
                    String dataProviderVariable = dataProviderVariables.get(i);
                    if (!previousDataTableVariable.equals(dataProviderVariable)) continue;
                    result.add(dataProviders[i]);
                    continue block0;
                }
                throw new IllegalStateException(String.format("Variable name not defined (%s not in %s)!", previousDataTableVariable, dataProviderVariables));
            }
            return result.toArray();
        }
    }

    private static class DataProcessorIterator
    extends BaseDataIterator {
        private final IDataIterator delegate;
        private final List<String> dataVariableNames;

        private DataProcessorIterator(IRunSupervisor supervisor, SpockExecutionContext context, IDataIterator delegate) {
            super(supervisor, context);
            this.delegate = delegate;
            this.dataVariableNames = this.readDataVariableNames();
        }

        @NotNull
        private List<String> readDataVariableNames() {
            return Collections.unmodifiableList(Arrays.asList(this.context.getCurrentFeature().getDataProcessorMethod().getAnnotation(DataProcessorMetadata.class).dataVariables()));
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.delegate.getEstimatedNumIterations();
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object[] next() {
            Object[] next = (Object[])this.delegate.next();
            if (next == null) {
                return null;
            }
            try {
                return (Object[])this.invokeRaw(this.context.getSharedInstance(), this.context.getCurrentFeature().getDataProcessorMethod(), next);
            }
            catch (Throwable t) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(this.context.getCurrentFeature().getDataProcessorMethod(), t, this.getErrorContext()));
                return null;
            }
        }
    }

    private static class IterationFilterIterator
    extends BaseDataIterator {
        private final IDataIterator delegate;
        private final List<String> dataVariableNames;
        private final boolean logFilteredIterations;
        private IStackTraceFilter stackTraceFilter;

        private IterationFilterIterator(IRunSupervisor supervisor, SpockExecutionContext context, IDataIterator delegate) {
            super(supervisor, context);
            this.delegate = delegate;
            this.dataVariableNames = delegate.getDataVariableNames();
            RunnerConfiguration runnerConfiguration = context.getRunContext().getConfiguration(RunnerConfiguration.class);
            this.logFilteredIterations = runnerConfiguration.logFilteredIterations;
            if (this.logFilteredIterations) {
                this.stackTraceFilter = runnerConfiguration.filterStackTrace ? new StackTraceFilter(context.getSpec()) : new DummyStackTraceFilter();
            }
        }

        @Override
        public int getEstimatedNumIterations() {
            return this.delegate.getEstimatedNumIterations();
        }

        @Override
        public List<String> getDataVariableNames() {
            return this.dataVariableNames;
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object[] next() {
            Object[] next;
            while ((next = (Object[])this.delegate.next()) != null) {
                MethodInfo filterMethod = this.context.getCurrentFeature().getFilterMethod();
                if (filterMethod == null) {
                    return next;
                }
                try {
                    filterMethod.invoke(this.context.getSharedInstance(), next);
                    return next;
                }
                catch (AssertionError ae) {
                    if (!this.logFilteredIterations) continue;
                    StringJoiner stringJoiner = new StringJoiner(", ", "Filtered iteration [", "]:\n");
                    for (int i = 0; i < this.dataVariableNames.size(); ++i) {
                        stringJoiner.add(this.dataVariableNames.get(i) + ": " + next[i]);
                    }
                    StringWriter sw = new StringWriter();
                    sw.write(stringJoiner.toString());
                    this.stackTraceFilter.filter((Throwable)((Object)ae));
                    try (PrintWriter pw = new PrintWriter(sw);){
                        ((Throwable)((Object)ae)).printStackTrace(pw);
                    }
                    System.err.println(sw);
                    continue;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(filterMethod, t, this.getErrorContext()));
                    return null;
                }
                break;
            }
            return null;
        }
    }

    private static class SingleEmptyIterationDataIterator
    implements IDataIterator {
        public static final List<Object[]> DEFAULT_PARAMS = Collections.singletonList(new Object[0]);
        private final Iterator<Object[]> delegate = DEFAULT_PARAMS.iterator();

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object[] next() {
            return this.delegate.next();
        }

        @Override
        public int getEstimatedNumIterations() {
            return 1;
        }

        @Override
        public List<String> getDataVariableNames() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws Exception {
        }
    }

    private static abstract class BaseDataIterator
    implements IDataIterator {
        protected final IRunSupervisor supervisor;
        protected final SpockExecutionContext context;

        public BaseDataIterator(IRunSupervisor supervisor, SpockExecutionContext context) {
            this.supervisor = supervisor;
            this.context = context;
        }

        protected Object invokeRaw(Object target, MethodInfo method, Object ... arguments) {
            try {
                return method.invoke(target, arguments);
            }
            catch (Throwable throwable) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(method, throwable, this.getErrorContext()));
                return null;
            }
        }

        protected IErrorContext getErrorContext() {
            return ErrorContext.from((SpecificationContext)this.context.getCurrentInstance().getSpecificationContext());
        }

        protected int estimateNumIterations(Object dataProvider) {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return -1;
            }
            if (dataProvider == null) {
                return -1;
            }
            if (dataProvider instanceof IDataIterator) {
                return ((IDataIterator)dataProvider).getEstimatedNumIterations();
            }
            if (dataProvider instanceof Iterator) {
                return -1;
            }
            Object rawSize = GroovyRuntimeUtil.invokeMethodQuietly(dataProvider, "size", new Object[0]);
            if (!(rawSize instanceof Number)) {
                return -1;
            }
            int size = ((Number)rawSize).intValue();
            if (size < 0) {
                return -1;
            }
            return size;
        }

        protected int estimateNumIterations(Object[] dataProviders) {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return -1;
            }
            if (dataProviders.length == 0) {
                return 1;
            }
            int result = Integer.MAX_VALUE;
            for (Object prov : dataProviders) {
                int size = this.estimateNumIterations(prov);
                if (size < 0 || size >= result) continue;
                result = size;
            }
            return result == Integer.MAX_VALUE ? -1 : result;
        }

        protected boolean haveNext(Iterator<?>[] iterators, List<DataProviderInfo> dataProviderInfos) {
            Assert.that(iterators.length == dataProviderInfos.size());
            boolean result = true;
            for (int i = 0; i < iterators.length; ++i) {
                try {
                    boolean hasNext;
                    if (i == 0) {
                        result = iterators[0].hasNext();
                        continue;
                    }
                    if (iterators[i] == null || result == (hasNext = iterators[i].hasNext())) continue;
                    DataProviderInfo provider = dataProviderInfos.get(i);
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(provider.getDataProviderMethod(), this.createDifferentNumberOfDataValuesException(provider, hasNext), this.getErrorContext()));
                    return false;
                }
                catch (Throwable t) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(dataProviderInfos.get(i).getDataProviderMethod(), t, this.getErrorContext()));
                    return false;
                }
            }
            return result;
        }

        protected Iterator<?> createIterator(Object dataProvider, DataProviderInfo dataProviderInfo) {
            if (this.context.getErrorInfoCollector().hasErrors()) {
                return null;
            }
            try {
                Iterator<Object> iter = GroovyRuntimeUtil.asIterator(dataProvider);
                if (iter == null) {
                    this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(dataProviderInfo.getDataProviderMethod(), new SpockExecutionException("Data provider's iterator() method returned null"), this.getErrorContext()));
                    return null;
                }
                return iter;
            }
            catch (Throwable t) {
                this.supervisor.error(this.context.getErrorInfoCollector(), new ErrorInfo(dataProviderInfo.getDataProviderMethod(), t, this.getErrorContext()));
                return null;
            }
        }

        private SpockExecutionException createDifferentNumberOfDataValuesException(DataProviderInfo provider, boolean hasNext) {
            String msg = String.format("Data provider for variable '%s' has %s values than previous data provider(s)", provider.getDataVariables().get(0), hasNext ? "more" : "fewer");
            SpockExecutionException exception = new SpockExecutionException(msg);
            FeatureInfo feature = (FeatureInfo)provider.getParent();
            SpecInfo spec = (SpecInfo)feature.getParent();
            StackTraceElement elem = new StackTraceElement(((Class)spec.getReflection()).getName(), feature.getName(), spec.getFilename(), provider.getLine());
            exception.setStackTrace(new StackTraceElement[]{elem});
            return exception;
        }
    }
}

